/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.services.sns.model.Topic;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopicStaxUnmarshaller
implements Unmarshaller<Topic, StaxUnmarshallerContext> {
    private static TopicStaxUnmarshaller instance;

    @Override
    public Topic unmarshall(StaxUnmarshallerContext context) throws Exception {
        Topic topic = new Topic();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return topic;
            }
            if (xmlEvent == 2) {
                if (!context.testExpression("TopicArn", targetDepth)) continue;
                topic.setTopicArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return topic;
    }

    public static TopicStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new TopicStaxUnmarshaller();
        }
        return instance;
    }
}

