/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.services.sqs.model.MessageAttributeValue;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageAttributeValueStaxUnmarshaller
implements Unmarshaller<MessageAttributeValue, StaxUnmarshallerContext> {
    private static MessageAttributeValueStaxUnmarshaller instance;

    @Override
    public MessageAttributeValue unmarshall(StaxUnmarshallerContext context) throws Exception {
        MessageAttributeValue messageAttributeValue = new MessageAttributeValue();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return messageAttributeValue;
            }
            if (xmlEvent == 2) {
                if (context.testExpression("StringValue", targetDepth)) {
                    messageAttributeValue.setStringValue(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("BinaryValue", targetDepth)) {
                    messageAttributeValue.setBinaryValue(SimpleTypeStaxUnmarshallers.ByteBufferStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StringListValue", targetDepth)) {
                    messageAttributeValue.getStringListValues().add(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("BinaryListValue", targetDepth)) {
                    messageAttributeValue.getBinaryListValues().add(SimpleTypeStaxUnmarshallers.ByteBufferStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("DataType", targetDepth)) continue;
                messageAttributeValue.setDataType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return messageAttributeValue;
    }

    public static MessageAttributeValueStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MessageAttributeValueStaxUnmarshaller();
        }
        return instance;
    }
}

