/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.services.sqs.model.SendMessageResult;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendMessageResultStaxUnmarshaller
implements Unmarshaller<SendMessageResult, StaxUnmarshallerContext> {
    private static SendMessageResultStaxUnmarshaller instance;

    @Override
    public SendMessageResult unmarshall(StaxUnmarshallerContext context) throws Exception {
        SendMessageResult sendMessageResult = new SendMessageResult();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return sendMessageResult;
            }
            if (xmlEvent == 2) {
                if (context.testExpression("MD5OfMessageBody", targetDepth)) {
                    sendMessageResult.setMD5OfMessageBody(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MD5OfMessageAttributes", targetDepth)) {
                    sendMessageResult.setMD5OfMessageAttributes(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("MessageId", targetDepth)) continue;
                sendMessageResult.setMessageId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return sendMessageResult;
    }

    public static SendMessageResultStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SendMessageResultStaxUnmarshaller();
        }
        return instance;
    }
}

