/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.transform;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaxUnmarshallerContext {
    private int currentEventType;
    private final XmlPullParser xpp;
    public final Deque<String> stack = new LinkedList<String>();
    private String stackString = "";
    private Map<String, String> metadata = new HashMap<String, String>();
    private List<MetadataExpression> metadataExpressions = new ArrayList<MetadataExpression>();
    private final Map<String, String> headers;

    public StaxUnmarshallerContext(XmlPullParser xpp) {
        this(xpp, null);
    }

    public StaxUnmarshallerContext(XmlPullParser xpp, Map<String, String> headers) {
        this.xpp = xpp;
        this.headers = headers;
    }

    public String getHeader(String header) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.get(header);
    }

    public String readText() throws XmlPullParserException, IOException {
        String s = this.xpp.nextText();
        if (this.xpp.getEventType() != 3) {
            this.xpp.next();
        }
        this.currentEventType = this.xpp.getEventType();
        this.updateContext();
        return s;
    }

    public int getCurrentDepth() {
        return this.stack.size();
    }

    public boolean testExpression(String expression) {
        return this.testExpression(expression, this.getCurrentDepth());
    }

    public boolean testExpression(String expression, int startingStackDepth) {
        if (expression.equals(".")) {
            return true;
        }
        int index = -1;
        while ((index = expression.indexOf("/", index + 1)) > -1) {
            if (expression.charAt(index + 1) == '@') continue;
            ++startingStackDepth;
        }
        return this.getCurrentDepth() == startingStackDepth && this.stackString.endsWith("/" + expression);
    }

    public boolean isStartOfDocument() {
        return this.currentEventType == 0;
    }

    public int nextEvent() throws XmlPullParserException, IOException {
        this.currentEventType = this.xpp.next();
        if (this.currentEventType == 4) {
            this.currentEventType = this.xpp.next();
        }
        this.updateContext();
        if (this.currentEventType == 2) {
            for (MetadataExpression metadataExpression : this.metadataExpressions) {
                if (!this.testExpression(metadataExpression.expression, metadataExpression.targetDepth)) continue;
                this.metadata.put(metadataExpression.key, this.readText());
                break;
            }
        }
        return this.currentEventType;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void registerMetadataExpression(String expression, int targetDepth, String storageKey) {
        this.metadataExpressions.add(new MetadataExpression(expression, targetDepth, storageKey));
    }

    private void updateContext() {
        if (this.currentEventType == 2) {
            this.stackString = this.stackString + "/" + this.xpp.getName();
            this.stack.push(this.stackString);
        } else if (this.currentEventType == 3) {
            this.stack.pop();
            this.stackString = this.stack.isEmpty() ? "" : this.stack.peek();
        }
    }

    private static class MetadataExpression {
        public String expression;
        public int targetDepth;
        public String key;

        public MetadataExpression(String expression, int targetDepth, String key) {
            this.expression = expression;
            this.targetDepth = targetDepth;
            this.key = key;
        }
    }
}

