/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.impl.geo;

import com.github.davidmoten.geo.GeoHash;
import com.github.fakemongo.impl.ExpressionParser;
import com.github.fakemongo.impl.Util;
import com.github.fakemongo.impl.geo.LatLong;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bson.BSONObject;

public final class GeoUtil {
    public static final double EARTH_RADIUS = 6374892.5;
    public static final int SIZE_GEOHASH = 5;

    private GeoUtil() {
    }

    public static double distanceInRadians(LatLong p1, LatLong p2, boolean spherical) {
        double distance = spherical ? GeoUtil.distanceSpherical(p1, p2) : GeoUtil.distance2d(p1, p2);
        return distance;
    }

    public static double distance2d(LatLong p1, LatLong p2) {
        double a = p1.getLat() - p2.getLat();
        double b = p1.getLon() - p2.getLon();
        if (a == 0.0) {
            return Math.abs(b);
        }
        if (b == 0.0) {
            return Math.abs(a);
        }
        return Math.sqrt(a * a + b * b);
    }

    public static double distanceSpherical(LatLong p1, LatLong p2) {
        double p1lat = Math.toRadians(p1.getLat());
        double p1long = Math.toRadians(p1.getLon());
        double p2lat = Math.toRadians(p2.getLat());
        double p2long = Math.toRadians(p2.getLon());
        double sinx1 = Math.sin(p1lat);
        double cosx1 = Math.cos(p1lat);
        double siny1 = Math.sin(p1long);
        double cosy1 = Math.cos(p1long);
        double sinx2 = Math.sin(p2lat);
        double cosx2 = Math.cos(p2lat);
        double siny2 = Math.sin(p2long);
        double cosy2 = Math.cos(p2long);
        double crossProduct = cosx1 * cosx2 * cosy1 * cosy2 + cosx1 * siny1 * cosx2 * siny2 + sinx1 * sinx2;
        if (crossProduct >= 1.0 || crossProduct <= -1.0) {
            return crossProduct > 0.0 ? 0.0 : Math.PI;
        }
        return Math.acos(crossProduct);
    }

    public static List<LatLong> latLon(List<String> path, DBObject object) {
        ExpressionParser expressionParser = new ExpressionParser();
        ArrayList<LatLong> result = new ArrayList<LatLong>();
        List<Object> objects = path.isEmpty() ? Collections.singletonList(object) : expressionParser.getEmbeddedValues(path, object);
        for (DBObject value : objects) {
            DBObject dbObject;
            LatLong latLong = null;
            if (value instanceof BasicDBList) {
                BasicDBList list = (BasicDBList)value;
                if (list.size() == 2) {
                    latLong = new LatLong(((Number)list.get(1)).doubleValue(), ((Number)list.get(0)).doubleValue());
                }
            } else if (value instanceof DBObject && (dbObject = value).containsField("lng") && dbObject.containsField("lat")) {
                latLong = new LatLong(((Number)dbObject.get("lat")).doubleValue(), ((Number)dbObject.get("lng")).doubleValue());
            }
            if (latLong == null) continue;
            result.add(latLong);
        }
        return result;
    }

    public static String encodeGeoHash(LatLong latLong) {
        return GeoUtil.encodeGeoHash(latLong, 5);
    }

    public static String encodeGeoHash(LatLong latLong, int sizeHash) {
        return GeoHash.encodeHash((com.github.davidmoten.geo.LatLong)latLong, (int)sizeHash);
    }

    public static LatLong decodeGeoHash(String geoHash) {
        return new LatLong(GeoHash.decodeHash((String)geoHash));
    }

    public static List<String> neightbours(String geoHash) {
        ArrayList<String> results = new ArrayList<String>();
        try {
            results.add(GeoHash.left((String)geoHash));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            results.add(GeoHash.right((String)geoHash));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            results.add(GeoHash.top((String)geoHash));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            results.add(GeoHash.bottom((String)geoHash));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return results;
    }

    public static class GeoDBObject
    extends BasicDBObject {
        private final String geoHash;
        private final LatLong latLong;

        public GeoDBObject(DBObject object, String indexKey) {
            List<LatLong> latLongs = GeoUtil.latLon(Util.split(indexKey), object);
            this.latLong = latLongs.get(0);
            this.geoHash = GeoUtil.encodeGeoHash(this.getLatLong());
            this.putAll((BSONObject)object);
        }

        public String getGeoHash() {
            return this.geoHash;
        }

        public LatLong getLatLong() {
            return this.latLong;
        }

        public int hashCode() {
            return this.getGeoHash().hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GeoDBObject)) {
                return false;
            }
            GeoDBObject that = (GeoDBObject)((Object)o);
            return this.getGeoHash().equals(that.getGeoHash());
        }

        public String toString() {
            return "GeoDBObject{geoHash='" + this.getGeoHash() + '\'' + ", latLong=" + (Object)((Object)this.getLatLong()) + '}';
        }
    }
}

