/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.impl.index;

import com.github.fakemongo.impl.ExpressionParser;
import com.github.fakemongo.impl.Filter;
import com.github.fakemongo.impl.Util;
import com.mongodb.DBObject;
import com.mongodb.FongoDBCollection;
import com.mongodb.MongoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class IndexAbstract<T extends DBObject> {
    private final String name;
    private final DBObject keys;
    private final Set<String> fields;
    private final boolean unique;
    final String geoIndex;
    final ExpressionParser expressionParser = new ExpressionParser();
    final Map<T, List<T>> mapValues;
    int lookupCount = 0;

    IndexAbstract(String name, DBObject keys, boolean unique, Map<T, List<T>> mapValues, String geoIndex) throws MongoException {
        this.name = name;
        this.fields = Collections.unmodifiableSet(keys.keySet());
        this.keys = this.prepareKeys(keys);
        this.unique = unique;
        this.mapValues = mapValues;
        this.geoIndex = geoIndex;
        for (Object value : keys.toMap().values()) {
            if (value instanceof String || value instanceof Number) continue;
            throw new MongoException(10098, "bad index key pattern : " + keys);
        }
    }

    private DBObject prepareKeys(DBObject keys) {
        DBObject nKeys = Util.clone(keys);
        if (!nKeys.containsField("_id")) {
            nKeys.put("_id", (Object)0);
        }
        for (Map.Entry<String, Object> entry : Util.entrySet(keys)) {
            if (!entry.getValue().equals("2d")) continue;
            nKeys.put(entry.getKey(), (Object)1);
        }
        return nKeys;
    }

    static boolean isAsc(DBObject keys) {
        Object value = keys.toMap().values().iterator().next();
        if (value instanceof Number) {
            return ((Number)value).intValue() >= 1;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean isGeoIndex() {
        return this.geoIndex != null;
    }

    public DBObject getKeys() {
        return this.keys;
    }

    public Set<String> getFields() {
        return this.fields;
    }

    public List<List<Object>> addOrUpdate(DBObject object, DBObject oldObject) {
        if (oldObject != null) {
            this.remove(oldObject);
        }
        T key = this.getKeyFor(object);
        if (this.unique) {
            if (this.mapValues.containsKey(key)) {
                return this.extractFields(object, key.keySet());
            }
            this.mapValues.put(key, Collections.singletonList(this.embedded(object)));
        } else {
            List<T> values = this.mapValues.get(key);
            if (values == null) {
                values = new ArrayList<T>();
                this.mapValues.put(key, values);
            }
            T toAdd = this.embedded(object);
            values.add(toAdd);
        }
        return Collections.emptyList();
    }

    public abstract T embedded(DBObject var1);

    public List<List<Object>> checkAddOrUpdate(DBObject object, DBObject oldObject) {
        T key;
        List<T> objects;
        if (this.unique && (objects = this.mapValues.get(key = this.getKeyFor(object))) != null && !objects.contains(oldObject)) {
            List<List<Object>> fieldsForIndex = this.extractFields(object, this.getFields());
            return fieldsForIndex;
        }
        return Collections.emptyList();
    }

    public void remove(DBObject object) {
        T key = this.getKeyFor(object);
        List<T> values = this.mapValues.get(key);
        if (values != null) {
            if (values.size() == 1) {
                this.mapValues.remove(key);
            } else {
                values.remove(object);
            }
        }
    }

    public List<List<Object>> addAll(Iterable<DBObject> objects) {
        for (DBObject object : objects) {
            List<List<Object>> nonUnique;
            if (!this.canHandle(object.keySet()) || (nonUnique = this.addOrUpdate(object, null)).isEmpty()) continue;
            return nonUnique;
        }
        return Collections.emptyList();
    }

    public List<T> get(DBObject query) {
        if (!this.unique) {
            throw new IllegalStateException("get is only for unique index");
        }
        ++this.lookupCount;
        T key = this.getKeyFor(query);
        return this.mapValues.get(key);
    }

    public Collection<T> retrieveObjects(DBObject query) {
        if (this.unique && query.keySet().size() == 1 && !(query.toMap().values().iterator().next() instanceof DBObject)) {
            return this.get(query);
        }
        ++this.lookupCount;
        Filter filterKey = this.expressionParser.buildFilter(query, this.getFields());
        Filter filter = this.expressionParser.buildFilter(query);
        ArrayList<DBObject> result = new ArrayList<DBObject>();
        for (Map.Entry<T, List<T>> entry : this.mapValues.entrySet()) {
            if (!filterKey.apply((DBObject)entry.getKey())) continue;
            for (DBObject object : entry.getValue()) {
                if (!filter.apply(object)) continue;
                result.add(object);
            }
        }
        return result;
    }

    public long getLookupCount() {
        return this.lookupCount;
    }

    public int size() {
        int size = 0;
        if (this.unique) {
            size = this.mapValues.size();
        } else {
            for (Map.Entry<T, List<T>> entry : this.mapValues.entrySet()) {
                size += entry.getValue().size();
            }
        }
        return size;
    }

    public List<DBObject> values() {
        ArrayList<DBObject> values = new ArrayList<DBObject>(this.mapValues.size() * 10);
        for (List<T> objects : this.mapValues.values()) {
            values.addAll(objects);
        }
        return values;
    }

    public void clear() {
        this.mapValues.clear();
    }

    public boolean canHandle(Set<String> queryFields) {
        return queryFields.containsAll(this.fields);
    }

    public String toString() {
        return "Index{name='" + this.name + '\'' + '}';
    }

    T getKeyFor(DBObject object) {
        DBObject applyProjections = FongoDBCollection.applyProjections(object, this.keys);
        return (T)applyProjections;
    }

    private List<List<Object>> extractFields(DBObject dbObject, Collection<String> fields) {
        ArrayList<List<Object>> fieldValue = new ArrayList<List<Object>>();
        for (String field : fields) {
            List<Object> embeddedValues = this.expressionParser.getEmbeddedValues(field, dbObject);
            fieldValue.add(embeddedValues);
        }
        return fieldValue;
    }
}

