/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.github.fakemongo.Fongo;
import com.github.fakemongo.internal.objenesis.ObjenesisStd;
import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoOptions;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;

public class MockMongoClient
extends MongoClient {
    private static final MongoClientOptions clientOptions = MongoClientOptions.builder().build();
    private Fongo fongo;
    private MongoOptions options;

    public static MockMongoClient create(Fongo fongo) {
        MockMongoClient client = new ObjenesisStd().getInstantiatorOf(MockMongoClient.class).newInstance();
        client.options = new MongoOptions(clientOptions);
        client.fongo = fongo;
        client.setWriteConcern(clientOptions.getWriteConcern());
        return client;
    }

    public String toString() {
        return this.fongo.toString();
    }

    public Collection<DB> getUsedDatabases() {
        return this.fongo.getUsedDatabases();
    }

    public List<String> getDatabaseNames() {
        return this.fongo.getDatabaseNames();
    }

    public int getMaxBsonObjectSize() {
        return 0x400000;
    }

    public DB getDB(String dbname) {
        return this.fongo.getDB(dbname);
    }

    public void dropDatabase(String dbName) {
        this.fongo.dropDatabase(dbName);
    }

    boolean isMongosConnection() {
        return false;
    }

    public MongoOptions getMongoOptions() {
        return this.options;
    }

    public MongoClientOptions getMongoClientOptions() {
        return clientOptions;
    }
}

