/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.github.fakemongo.Fongo;
import com.github.fakemongo.impl.Aggregator;
import com.github.fakemongo.impl.MapReduce;
import com.mongodb.BasicDBList;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBObject;
import com.mongodb.FongoDBCollection;
import com.mongodb.Mongo;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FongoDB
extends DB {
    private static final Logger LOG = LoggerFactory.getLogger(FongoDB.class);
    private final Map<String, FongoDBCollection> collMap = Collections.synchronizedMap(new HashMap());
    private final Fongo fongo;
    private MongoCredential mongoCredential;

    public FongoDB(Fongo fongo, String name) {
        super((Mongo)fongo.getMongo(), name);
        this.fongo = fongo;
        this.doGetCollection("system.users");
        this.doGetCollection("system.indexes");
    }

    public void requestStart() {
    }

    public void requestDone() {
    }

    public void requestEnsureConnection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FongoDBCollection doGetCollection(String name) {
        Map<String, FongoDBCollection> map = this.collMap;
        synchronized (map) {
            FongoDBCollection coll = this.collMap.get(name);
            if (coll == null) {
                coll = new FongoDBCollection(this, name);
                this.collMap.put(name, coll);
            }
            return coll;
        }
    }

    private DBObject findAndModify(String collection, DBObject query, DBObject sort, boolean remove, DBObject update, boolean returnNew, DBObject fields, boolean upsert) {
        FongoDBCollection coll = this.doGetCollection(collection);
        return coll.findAndModify(query, fields, sort, remove, update, returnNew, upsert);
    }

    private List<DBObject> doAggregateCollection(String collection, List<DBObject> pipeline) {
        FongoDBCollection coll = this.doGetCollection(collection);
        Aggregator aggregator = new Aggregator(this, coll, pipeline);
        return aggregator.computeResult();
    }

    private DBObject doMapReduce(String collection, String map, String reduce, String finalize, DBObject out, DBObject query, DBObject sort, Number limit) {
        FongoDBCollection coll = this.doGetCollection(collection);
        MapReduce mapReduce = new MapReduce(this.fongo, coll, map, reduce, finalize, out, query, sort, limit);
        return mapReduce.computeResult();
    }

    private List<DBObject> doGeoNearCollection(String collection, DBObject near, DBObject query, Number limit, Number maxDistance, boolean spherical) {
        FongoDBCollection coll = this.doGetCollection(collection);
        return coll.geoNear(near, query, limit, maxDistance, spherical);
    }

    private DBObject doTextSearchInCollection(String collection, String search, Integer limit, DBObject project) {
        FongoDBCollection coll = this.doGetCollection(collection);
        return coll.text(search, limit, project);
    }

    public Set<String> getCollectionNames() throws MongoException {
        return new HashSet<String>(this.collMap.keySet());
    }

    public void cleanCursors(boolean force) throws MongoException {
    }

    public DB getSisterDB(String name) {
        return this.fongo.getDB(name);
    }

    public WriteConcern getWriteConcern() {
        return this.fongo.getWriteConcern();
    }

    public ReadPreference getReadPreference() {
        return ReadPreference.primaryPreferred();
    }

    public void dropDatabase() throws MongoException {
        this.fongo.dropDatabase(this.getName());
        for (FongoDBCollection c : new ArrayList<FongoDBCollection>(this.collMap.values())) {
            c.drop();
        }
    }

    CommandResult doAuthenticate(MongoCredential credentials) {
        this.mongoCredential = credentials;
        return this.okResult();
    }

    MongoCredential getAuthenticationCredentials() {
        return this.mongoCredential;
    }

    public CommandResult command(DBObject cmd, int options, ReadPreference readPrefs) throws MongoException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fongo got command " + cmd);
        }
        if (cmd.containsField("getlasterror")) {
            return this.okResult();
        }
        if (cmd.containsField("drop")) {
            this.collMap.remove(cmd.get("drop").toString());
            return this.okResult();
        }
        if (cmd.containsField("create")) {
            String collectionName = (String)cmd.get("create");
            this.doGetCollection(collectionName);
            return this.okResult();
        }
        if (cmd.containsField("count")) {
            String collectionName = (String)cmd.get("count");
            Number limit = (Number)cmd.get("limit");
            Number skip = (Number)cmd.get("skip");
            long result = this.doGetCollection(collectionName).getCount((DBObject)cmd.get("query"), null, limit == null ? 0L : limit.longValue(), skip == null ? 0L : skip.longValue());
            CommandResult okResult = this.okResult();
            okResult.append("n", (Object)result);
            return okResult;
        }
        if (cmd.containsField("deleteIndexes")) {
            String collectionName = (String)cmd.get("deleteIndexes");
            String indexName = (String)cmd.get("index");
            if ("*".equals(indexName)) {
                this.doGetCollection(collectionName)._dropIndexes();
            } else {
                this.doGetCollection(collectionName)._dropIndexes(indexName);
            }
            CommandResult okResult = this.okResult();
            return okResult;
        }
        if (cmd.containsField("aggregate")) {
            List<DBObject> result = this.doAggregateCollection((String)cmd.get("aggregate"), (List)cmd.get("pipeline"));
            if (result == null) {
                return this.notOkErrorResult("can't aggregate");
            }
            CommandResult okResult = this.okResult();
            BasicDBList list = new BasicDBList();
            list.addAll(result);
            okResult.put("result", (Object)list);
            return okResult;
        }
        if (cmd.containsField("findAndModify")) {
            DBObject result = this.findAndModify((String)cmd.get("findAndModify"), (DBObject)cmd.get("query"), (DBObject)cmd.get("sort"), Boolean.TRUE.equals(cmd.get("remove")), (DBObject)cmd.get("update"), Boolean.TRUE.equals(cmd.get("new")), (DBObject)cmd.get("fields"), Boolean.TRUE.equals(cmd.get("upsert")));
            CommandResult okResult = this.okResult();
            okResult.put("value", (Object)result);
            return okResult;
        }
        if (cmd.containsField("ping")) {
            CommandResult okResult = this.okResult();
            return okResult;
        }
        if (cmd.containsField("validate")) {
            CommandResult okResult = this.okResult();
            return okResult;
        }
        if (cmd.containsField("buildInfo")) {
            CommandResult okResult = this.okResult();
            okResult.put("version", (Object)"2.4.5");
            okResult.put("maxBsonObjectSize", (Object)0x1000000);
            return okResult;
        }
        if (cmd.containsField("forceerror")) {
            CommandResult result = this.notOkErrorResult(10038, null, "exception: forced error");
            return result;
        }
        if (cmd.containsField("mapreduce")) {
            DBObject result = this.doMapReduce((String)cmd.get("mapreduce"), (String)cmd.get("map"), (String)cmd.get("reduce"), (String)cmd.get("finalize"), (DBObject)cmd.get("out"), (DBObject)cmd.get("query"), (DBObject)cmd.get("sort"), (Number)cmd.get("limit"));
            if (result == null) {
                return this.notOkErrorResult("can't mapReduce");
            }
            CommandResult okResult = this.okResult();
            if (result instanceof List) {
                okResult.put("results", (Object)result);
            } else {
                okResult.put("result", (Object)result);
            }
            return okResult;
        }
        if (cmd.containsField("geoNear")) {
            try {
                List<DBObject> result = this.doGeoNearCollection((String)cmd.get("geoNear"), (DBObject)cmd.get("near"), (DBObject)cmd.get("query"), (Number)cmd.get("limit"), (Number)cmd.get("maxDistance"), Boolean.TRUE.equals(cmd.get("spherical")));
                if (result == null) {
                    return this.notOkErrorResult("can't geoNear");
                }
                CommandResult okResult = this.okResult();
                BasicDBList list = new BasicDBList();
                list.addAll(result);
                okResult.put("results", (Object)list);
                return okResult;
            }
            catch (MongoException me) {
                CommandResult result = this.errorResult(me.getCode(), me.getMessage());
                return result;
            }
        }
        String collectionName = (String)cmd.toMap().entrySet().iterator().next().getKey();
        if (this.collectionExists(collectionName)) {
            DBObject newCmd = (DBObject)cmd.get(collectionName);
            if (newCmd.containsField("text") && ((DBObject)newCmd.get("text")).containsField("search")) {
                DBObject resp = this.doTextSearchInCollection(collectionName, (String)((DBObject)newCmd.get("text")).get("search"), (Integer)((DBObject)newCmd.get("text")).get("limit"), (DBObject)((DBObject)newCmd.get("text")).get("project"));
                if (resp == null) {
                    return this.notOkErrorResult("can't perform text search");
                }
                CommandResult okResult = this.okResult();
                okResult.put("results", resp.get("results"));
                okResult.put("stats", resp.get("stats"));
                return okResult;
            }
            if (newCmd.containsField("$text") && ((DBObject)newCmd.get("$text")).containsField("$search")) {
                DBObject resp = this.doTextSearchInCollection(collectionName, (String)((DBObject)newCmd.get("$text")).get("$search"), (Integer)((DBObject)newCmd.get("text")).get("limit"), (DBObject)((DBObject)newCmd.get("text")).get("project"));
                if (resp == null) {
                    return this.notOkErrorResult("can't perform text search");
                }
                CommandResult okResult = this.okResult();
                okResult.put("results", resp.get("results"));
                okResult.put("stats", resp.get("stats"));
                return okResult;
            }
        }
        String command = cmd.toString();
        if (!cmd.keySet().isEmpty()) {
            command = (String)cmd.keySet().iterator().next();
        }
        return this.notOkErrorResult(null, "no such cmd: " + command);
    }

    public CommandResult okResult() {
        CommandResult result = new CommandResult(this.fongo.getServerAddress());
        result.put("ok", (Object)1.0);
        return result;
    }

    public CommandResult notOkErrorResult(String err) {
        return this.notOkErrorResult(err, null);
    }

    public CommandResult notOkErrorResult(String err, String errmsg) {
        CommandResult result = new CommandResult(this.fongo.getServerAddress());
        result.put("ok", (Object)0.0);
        if (err != null) {
            result.put("err", (Object)err);
        }
        if (errmsg != null) {
            result.put("errmsg", (Object)errmsg);
        }
        return result;
    }

    public CommandResult notOkErrorResult(int code, String err) {
        CommandResult result = this.notOkErrorResult(err);
        result.put("code", (Object)code);
        return result;
    }

    public CommandResult notOkErrorResult(int code, String err, String errmsg) {
        CommandResult result = this.notOkErrorResult(err, errmsg);
        result.put("code", (Object)code);
        return result;
    }

    public CommandResult errorResult(int code, String err) {
        CommandResult result = this.okResult();
        result.put("err", (Object)err);
        result.put("code", (Object)code);
        return result;
    }

    public String toString() {
        return "FongoDB." + this.getName();
    }

    public void removeCollection(FongoDBCollection collection) {
        this.collMap.remove(collection.getName());
    }

    public void addCollection(FongoDBCollection collection) {
        this.collMap.put(collection.getName(), collection);
    }
}

