/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.github.fakemongo.FongoException;
import com.github.fakemongo.impl.ExpressionParser;
import com.github.fakemongo.impl.Filter;
import com.github.fakemongo.impl.Tuple2;
import com.github.fakemongo.impl.UpdateEngine;
import com.github.fakemongo.impl.Util;
import com.github.fakemongo.impl.geo.GeoUtil;
import com.github.fakemongo.impl.geo.LatLong;
import com.github.fakemongo.impl.index.GeoIndex;
import com.github.fakemongo.impl.index.IndexAbstract;
import com.github.fakemongo.impl.index.IndexFactory;
import com.github.fakemongo.impl.text.TextSearch;
import com.github.fakemongo.internal.objenesis.ObjenesisStd;
import com.mongodb.AcknowledgedBulkWriteResult;
import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.BulkWriteResult;
import com.mongodb.BulkWriteUpsert;
import com.mongodb.CommandResult;
import com.mongodb.Cursor;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBDecoder;
import com.mongodb.DBEncoder;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.mongodb.DefaultDBDecoder;
import com.mongodb.DefaultDBEncoder;
import com.mongodb.FongoDB;
import com.mongodb.InsertRequest;
import com.mongodb.LazyDBObject;
import com.mongodb.ModifyRequest;
import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.ParallelScanOptions;
import com.mongodb.QueryOpBuilder;
import com.mongodb.QueryResultIterator;
import com.mongodb.ReadPreference;
import com.mongodb.RemoveRequest;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernException;
import com.mongodb.WriteRequest;
import com.mongodb.WriteResult;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.bson.BSON;
import org.bson.BSONObject;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.OutputBuffer;
import org.bson.types.Binary;
import org.bson.types.ObjectId;
import org.bson.util.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class FongoDBCollection
extends DBCollection {
    private static final Logger LOG = LoggerFactory.getLogger(FongoDBCollection.class);
    public static final String ID_KEY = "_id";
    public static final String FONGO_SPECIAL_ORDER_BY = "$$$$$FONGO_ORDER_BY$$$$$";
    private static final String ID_NAME_INDEX = "_id_";
    private final FongoDB fongoDb;
    private final ExpressionParser expressionParser;
    private final UpdateEngine updateEngine;
    private final boolean nonIdCollection;
    private final ExpressionParser.ObjectComparator objectComparator;
    private final List<IndexAbstract> indexes = new ArrayList<IndexAbstract>();
    private final IndexAbstract _idIndex;

    public FongoDBCollection(FongoDB db, String name) {
        super((DB)db, name);
        this.fongoDb = db;
        this.nonIdCollection = name.startsWith("system");
        this.expressionParser = new ExpressionParser();
        this.updateEngine = new UpdateEngine();
        this.objectComparator = this.expressionParser.buildObjectComparator(true);
        this._idIndex = IndexFactory.create(ID_KEY, (DBObject)new BasicDBObject(ID_KEY, (Object)1), true);
        this.indexes.add(this._idIndex);
        if (!this.nonIdCollection) {
            this.createIndex((DBObject)new BasicDBObject(ID_KEY, (Object)1), (DBObject)new BasicDBObject("name", (Object)ID_NAME_INDEX));
        }
    }

    private CommandResult insertResult(int updateCount) {
        CommandResult result = this.fongoDb.okResult();
        result.put("n", (Object)updateCount);
        return result;
    }

    private CommandResult updateResult(int updateCount, boolean updatedExisting) {
        CommandResult result = this.fongoDb.okResult();
        result.put("n", (Object)updateCount);
        result.put("updatedExisting", (Object)updatedExisting);
        return result;
    }

    public synchronized WriteResult insert(DBObject[] arr, WriteConcern concern, DBEncoder encoder) throws MongoException {
        return this.insert(Arrays.asList(arr), concern, encoder);
    }

    private DBObject encodeDecode(DBObject dbObject, DBEncoder encoder) {
        if (dbObject instanceof LazyDBObject) {
            if (encoder == null) {
                encoder = DefaultDBEncoder.FACTORY.create();
            }
            BasicOutputBuffer outputBuffer = new BasicOutputBuffer();
            encoder.writeObject((OutputBuffer)outputBuffer, (BSONObject)dbObject);
            return DefaultDBDecoder.FACTORY.create().decode(outputBuffer.toByteArray(), (DBCollection)this);
        }
        return dbObject;
    }

    public synchronized WriteResult insert(List<DBObject> toInsert, WriteConcern concern, DBEncoder encoder) {
        for (DBObject obj : toInsert) {
            DBObject cloned = this.filterLists(Util.cloneIdFirst(this.encodeDecode(obj, encoder)));
            if (LOG.isDebugEnabled()) {
                LOG.debug("insert: " + cloned);
            }
            ObjectId id = this.putIdIfNotPresent(cloned);
            if (!(obj instanceof LazyDBObject) && obj.get(ID_KEY) == null) {
                obj.put(ID_KEY, Util.clone(id));
            }
            this.putSizeCheck(cloned, concern);
        }
        return new WriteResult(this.insertResult(toInsert.size()), concern);
    }

    boolean enforceDuplicates(WriteConcern concern) {
        WriteConcern writeConcern = concern == null ? this.getWriteConcern() : concern;
        return writeConcern._w instanceof Number && ((Number)writeConcern._w).intValue() > 0;
    }

    public ObjectId putIdIfNotPresent(DBObject obj) {
        Object object = obj.get(ID_KEY);
        if (object == null) {
            ObjectId id = new ObjectId(new Date());
            id.notNew();
            obj.put(ID_KEY, Util.clone(id));
            return id;
        }
        if (object instanceof ObjectId) {
            ObjectId id = (ObjectId)object;
            id.notNew();
            return id;
        }
        return null;
    }

    public void putSizeCheck(DBObject obj, WriteConcern concern) {
        if (this._idIndex.size() > 100000) {
            throw new FongoException("Whoa, hold up there.  Fongo's designed for lightweight testing.  100,000 items per collection max");
        }
        this.addToIndexes(obj, null, concern);
    }

    public DBObject filterLists(DBObject dbo) {
        if (dbo == null) {
            return null;
        }
        dbo = Util.clone(dbo);
        for (Map.Entry<String, Object> entry : Util.entrySet(dbo)) {
            Object replacementValue = this.replaceListAndMap(entry.getValue());
            dbo.put(entry.getKey(), replacementValue);
        }
        return dbo;
    }

    public Object replaceListAndMap(Object value) {
        Object replacementValue = BSON.applyEncodingHooks((Object)value);
        if (replacementValue instanceof DBObject) {
            replacementValue = this.filterLists((DBObject)replacementValue);
        } else if (replacementValue instanceof List) {
            BasicDBList list = new BasicDBList();
            for (Object listItem : (List)replacementValue) {
                list.add(this.replaceListAndMap(listItem));
            }
            replacementValue = list;
        } else if (replacementValue instanceof Object[]) {
            BasicDBList list = new BasicDBList();
            for (Object listItem : (Object[])replacementValue) {
                list.add(this.replaceListAndMap(listItem));
            }
            replacementValue = list;
        } else if (replacementValue instanceof Map) {
            BasicDBObject newDbo = new BasicDBObject();
            for (Map.Entry entry : ((Map)replacementValue).entrySet()) {
                newDbo.put((String)entry.getKey(), this.replaceListAndMap(entry.getValue()));
            }
            replacementValue = newDbo;
        } else if (replacementValue instanceof Binary) {
            replacementValue = ((Binary)replacementValue).getData();
        }
        return replacementValue;
    }

    protected void fInsert(DBObject obj, WriteConcern concern) {
        this.putIdIfNotPresent(obj);
        this.putSizeCheck(obj, concern);
    }

    public synchronized WriteResult update(DBObject q, DBObject o, boolean upsert, boolean multi, WriteConcern concern, DBEncoder encoder) throws MongoException {
        q = this.filterLists(q);
        o = this.filterLists(o);
        if (LOG.isDebugEnabled()) {
            LOG.debug("update(" + q + ", " + o + ", " + upsert + ", " + multi + ")");
        }
        if (o.containsField(ID_KEY) && q.containsField(ID_KEY) && this.objectComparator.compare(o.get(ID_KEY), q.get(ID_KEY)) != 0) {
            LOG.warn("can not change _id of a document query={}, document={}", (Object)q, (Object)o);
            throw new WriteConcernException(this.fongoDb.notOkErrorResult(16836, "can not change _id of a document _id"));
        }
        int updatedDocuments = 0;
        boolean idOnlyUpdate = q.containsField(ID_KEY) && q.keySet().size() == 1;
        boolean updatedExisting = false;
        if (idOnlyUpdate && this.isNotUpdateCommand(o)) {
            if (!o.containsField(ID_KEY)) {
                o.put(ID_KEY, Util.clone(q.get(ID_KEY)));
            } else {
                o.put(ID_KEY, Util.clone(o.get(ID_KEY)));
            }
            Iterator oldObjects = this._idIndex.retrieveObjects(q).iterator();
            this.addToIndexes(Util.clone(o), oldObjects.hasNext() ? (DBObject)oldObjects.next() : null, concern);
            ++updatedDocuments;
        } else {
            Filter filter = this.expressionParser.buildFilter(q);
            for (DBObject obj : this.filterByIndexes(q)) {
                if (!filter.apply(obj)) continue;
                DBObject newObject = Util.clone(obj);
                this.updateEngine.doUpdate(newObject, o, q, false);
                this.addToIndexes(newObject, obj, concern);
                ++updatedDocuments;
                updatedExisting = true;
                if (multi) continue;
                break;
            }
            if (updatedDocuments == 0 && upsert) {
                BasicDBObject newObject = this.createUpsertObject(q);
                this.fInsert(this.updateEngine.doUpdate((DBObject)newObject, o, q, true), concern);
                ++updatedDocuments;
                updatedExisting = false;
            }
        }
        return new WriteResult(this.updateResult(updatedDocuments, updatedExisting), concern);
    }

    private List idsIn(DBObject query) {
        Object idValue = query.get(ID_KEY);
        if (idValue == null || query.keySet().size() > 1) {
            return Collections.emptyList();
        }
        if (idValue instanceof DBObject) {
            DBObject idDbObject = (DBObject)idValue;
            Collection inList = (Collection)idDbObject.get("$in");
            if (inList != null) {
                Object[] inListArray = inList.toArray(new Object[inList.size()]);
                Arrays.sort(inListArray, this.objectComparator);
                return Arrays.asList(inListArray);
            }
            if (!this.isNotUpdateCommand(idValue)) {
                return Collections.emptyList();
            }
        }
        return Collections.singletonList(Util.clone(idValue));
    }

    protected BasicDBObject createUpsertObject(DBObject q) {
        BasicDBObject newObject = new BasicDBObject();
        newObject.markAsPartialObject();
        List idsIn = this.idsIn(q);
        if (!idsIn.isEmpty()) {
            newObject.put(ID_KEY, Util.clone(idsIn.get(0)));
        } else {
            BasicDBObject filteredQuery = new BasicDBObject();
            for (String key : q.keySet()) {
                Object value = q.get(key);
                if (!this.isNotUpdateCommand(value)) continue;
                filteredQuery.put(key, value);
            }
            this.updateEngine.mergeEmbeddedValueFromQuery(newObject, (DBObject)filteredQuery);
        }
        return newObject;
    }

    public boolean isNotUpdateCommand(Object value) {
        boolean okValue = true;
        if (value instanceof DBObject) {
            for (String innerKey : ((DBObject)value).keySet()) {
                if (!innerKey.startsWith("$")) continue;
                okValue = false;
            }
        }
        return okValue;
    }

    protected void doapply(DBObject o) {
    }

    public synchronized WriteResult remove(DBObject o, WriteConcern concern, DBEncoder encoder) throws MongoException {
        o = this.filterLists(o);
        if (LOG.isDebugEnabled()) {
            LOG.debug("remove: " + o);
        }
        int updatedDocuments = 0;
        Collection<DBObject> objectsByIndex = this.filterByIndexes(o);
        Filter filter = this.expressionParser.buildFilter(o);
        ArrayList<DBObject> ids = new ArrayList<DBObject>();
        for (DBObject object : objectsByIndex) {
            if (!filter.apply(object)) continue;
            ids.add(object);
        }
        for (DBObject object : ids) {
            LOG.debug("remove object : {}", (Object)object);
            this.removeFromIndexes(object);
            ++updatedDocuments;
        }
        return new WriteResult(this.updateResult(updatedDocuments, false), concern);
    }

    QueryResultIterator find(DBObject ref, DBObject fields, int numToSkip, int batchSize, int limit, int options, ReadPreference readPref, DBDecoder decoder) {
        return this.find(ref, fields, numToSkip, batchSize, limit, options, readPref, decoder, null);
    }

    synchronized QueryResultIterator find(DBObject ref, DBObject fields, int numToSkip, int batchSize, int limit, int options, ReadPreference readPref, DBDecoder decoder, DBEncoder encoder) {
        Iterator<DBObject> values = this.__find(ref, fields, numToSkip, batchSize, limit, options, readPref, decoder, encoder);
        return this.createQueryResultIterator(values);
    }

    public synchronized void createIndex(DBObject keys, DBObject options, DBEncoder encoder) throws MongoException {
        boolean unique;
        DBCollection indexColl = this.fongoDb.getCollection("system.indexes");
        BasicDBObject rec = new BasicDBObject();
        rec.append("v", (Object)1);
        rec.append("key", (Object)keys);
        rec.append("ns", (Object)(this.getDB().getName() + "." + this.getName()));
        if (options != null && options.containsField("name")) {
            rec.append("name", options.get("name"));
        } else {
            StringBuilder sb = new StringBuilder();
            boolean firstLoop = true;
            for (String keyName : keys.keySet()) {
                if (!firstLoop) {
                    sb.append("_");
                }
                sb.append(keyName).append("_").append(keys.get(keyName));
                firstLoop = false;
            }
            rec.append("name", (Object)sb.toString());
        }
        if (indexColl.findOne((DBObject)rec) != null) {
            return;
        }
        boolean bl = unique = options != null && options.get("unique") != null && (Boolean.TRUE.equals(options.get("unique")) || "1".equals(options.get("unique")) || Integer.valueOf(1).equals(options.get("unique")));
        if (unique) {
            rec.append("unique", (Object)unique);
        }
        rec.putAll((BSONObject)options);
        try {
            IndexAbstract index = IndexFactory.create((String)rec.get("name"), keys, unique);
            List<List<Object>> notUnique = index.addAll(this._idIndex.values());
            if (!notUnique.isEmpty()) {
                if (this.enforceDuplicates(this.getWriteConcern())) {
                    this.fongoDb.errorResult(11000, "E11000 duplicate key error index: " + this.getFullName() + ".$" + rec.get("name") + "  dup key: { : " + notUnique + " }").throwOnError();
                }
                return;
            }
            this.indexes.add(index);
        }
        catch (MongoException me) {
            this.fongoDb.errorResult(me.getCode(), me.getMessage()).throwOnError();
        }
        indexColl.insert(new DBObject[]{rec});
    }

    public DBObject findOne(DBObject query, DBObject fields, DBObject orderBy, ReadPreference readPref) {
        QueryOpBuilder queryOpBuilder = new QueryOpBuilder().addQuery(query).addOrderBy(orderBy);
        Iterator<DBObject> resultIterator = this.__find(queryOpBuilder.get(), fields, 0, 1, -1, 0, readPref, null);
        return resultIterator.hasNext() ? this.replaceWithObjectClass(resultIterator.next()) : null;
    }

    Iterator<DBObject> __find(DBObject ref, DBObject fields, int numToSkip, int batchSize, int limit, int options, ReadPreference readPref, DBDecoder decoder, DBEncoder encoder) {
        return this.__find(ref, fields, numToSkip, batchSize, limit, options, readPref, decoder);
    }

    synchronized Iterator<DBObject> __find(DBObject pRef, DBObject fields, int numToSkip, int batchSize, int limit, int options, ReadPreference readPref, DBDecoder decoder) throws MongoException {
        DBObject ref = this.filterLists(pRef);
        long maxScan = Long.MAX_VALUE;
        if (LOG.isDebugEnabled()) {
            LOG.debug("find({}, {}).skip({}).limit({})", new Object[]{ref, fields, numToSkip, limit});
            LOG.debug("the db {} looks like {}", (Object)this.getDB().getName(), (Object)this._idIndex.size());
        }
        DBObject orderby = null;
        if (ref.containsField("$orderby")) {
            orderby = (DBObject)ref.get("$orderby");
        }
        if (ref.containsField("$maxScan")) {
            maxScan = ((Number)ref.get("$maxScan")).longValue();
        }
        if (ref.containsField("$query")) {
            ref = (DBObject)ref.get("$query");
        }
        Filter filter = this.expressionParser.buildFilter(ref);
        int foundCount = 0;
        int upperLimit = Integer.MAX_VALUE;
        if (limit > 0) {
            upperLimit = limit;
        }
        Collection<DBObject> objectsFromIndex = this.filterByIndexes(ref);
        List<DBObject> results = new ArrayList<DBObject>();
        List objects = this.idsIn(ref);
        if (!objects.isEmpty()) {
            if (!(ref.get(ID_KEY) instanceof DBObject)) {
                numToSkip = 0;
            }
            if (orderby == null) {
                orderby = new BasicDBObject(ID_KEY, (Object)1);
            } else {
                objectsFromIndex = this.sortObjects((DBObject)new BasicDBObject(ID_KEY, (Object)1), objectsFromIndex);
            }
        }
        int seen = 0;
        Collection<DBObject> objectsToSearch = this.sortObjects(orderby, objectsFromIndex);
        Iterator iter = objectsToSearch.iterator();
        while (iter.hasNext() && foundCount <= upperLimit && maxScan-- > 0L) {
            DBObject dbo = (DBObject)iter.next();
            if (!filter.apply(dbo) || seen++ < numToSkip) continue;
            ++foundCount;
            DBObject clonedDbo = Util.clone(dbo);
            if (this.nonIdCollection) {
                clonedDbo.removeField(ID_KEY);
            }
            clonedDbo.removeField(FONGO_SPECIAL_ORDER_BY);
            for (String key : clonedDbo.keySet()) {
                Object value = clonedDbo.get(key);
                if (!(value instanceof DBRef) || ((DBRef)value).getDB() != null) continue;
                clonedDbo.put(key, (Object)new DBRef(this.getDB(), ((DBRef)value).getRef(), ((DBRef)value).getId()));
            }
            results.add(clonedDbo);
        }
        if (!Util.isProjectionEmpty(fields)) {
            results = this.applyProjections(results, fields);
        }
        LOG.debug("found results {}", results);
        return this.replaceWithObjectClass(results).iterator();
    }

    private Collection<DBObject> filterByIndexes(DBObject ref) {
        IndexAbstract matchingIndex;
        Collection<Object> dbObjectIterable = null;
        if (ref != null && (matchingIndex = this.searchIndex(ref)) != null) {
            dbObjectIterable = matchingIndex.retrieveObjects(ref);
            if (LOG.isDebugEnabled()) {
                LOG.debug("restrict with index {}, from {} to {} elements", new Object[]{matchingIndex.getName(), this._idIndex.size(), dbObjectIterable == null ? 0 : dbObjectIterable.size()});
            }
        }
        if (dbObjectIterable == null) {
            dbObjectIterable = this._idIndex.values();
        }
        return dbObjectIterable;
    }

    private List<DBObject> applyProjections(List<DBObject> results, DBObject projection) {
        ArrayList<DBObject> ret = new ArrayList<DBObject>(results.size());
        for (DBObject result : results) {
            DBObject projectionMacthedResult = FongoDBCollection.applyProjections(result, projection);
            if (null == projectionMacthedResult) continue;
            ret.add(projectionMacthedResult);
        }
        return ret;
    }

    private static void addValuesAtPath(BasicDBObject ret, DBObject dbo, List<String> path, int startIndex) {
        String subKey = path.get(startIndex);
        Object value = dbo.get(subKey);
        if (path.size() > startIndex + 1) {
            if (value instanceof DBObject && !(value instanceof List)) {
                BasicDBObject nb = (BasicDBObject)ret.get(subKey);
                if (nb == null) {
                    nb = new BasicDBObject();
                }
                ret.append(subKey, (Object)nb);
                FongoDBCollection.addValuesAtPath(nb, (DBObject)value, path, startIndex + 1);
            } else if (value instanceof List) {
                BasicDBList list = FongoDBCollection.getListForKey(ret, subKey);
                int idx = 0;
                for (Object v : (List)value) {
                    if (v instanceof DBObject) {
                        BasicDBObject nb;
                        if (list.size() > idx) {
                            nb = (BasicDBObject)list.get(idx);
                        } else {
                            nb = new BasicDBObject();
                            list.add((Object)nb);
                        }
                        FongoDBCollection.addValuesAtPath(nb, (DBObject)v, path, startIndex + 1);
                    }
                    ++idx;
                }
            }
        } else if (value != null) {
            ret.append(subKey, value);
        }
    }

    private static BasicDBList getListForKey(BasicDBObject ret, String subKey) {
        BasicDBList list;
        if (ret.containsField(subKey)) {
            list = (BasicDBList)ret.get(subKey);
        } else {
            list = new BasicDBList();
            ret.append(subKey, (Object)list);
        }
        return list;
    }

    private DBObject replaceWithObjectClass(DBObject resultObject) {
        if (resultObject == null || this.getObjectClass() == null) {
            return resultObject;
        }
        DBObject targetObject = this.instantiateObjectClassInstance();
        for (String key : resultObject.keySet()) {
            targetObject.put(key, resultObject.get(key));
        }
        return targetObject;
    }

    private List<DBObject> replaceWithObjectClass(List<DBObject> resultObjects) {
        ArrayList<DBObject> targetObjects = new ArrayList<DBObject>(resultObjects.size());
        for (DBObject resultObject : resultObjects) {
            targetObjects.add(this.replaceWithObjectClass(resultObject));
        }
        return targetObjects;
    }

    private DBObject instantiateObjectClassInstance() {
        try {
            return (DBObject)this.getObjectClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new MongoInternalException("Can't create instance of type: " + this.getObjectClass(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new MongoInternalException("Can't create instance of type: " + this.getObjectClass(), (Throwable)e);
        }
    }

    public static DBObject applyProjections(DBObject result, DBObject projectionObject) {
        BasicDBObject ret;
        LOG.debug("applying projections {}", (Object)projectionObject);
        if (Util.isProjectionEmpty(projectionObject)) {
            return Util.cloneIdFirst(result);
        }
        if (result == null) {
            return null;
        }
        int inclusionCount = 0;
        int exclusionCount = 0;
        ArrayList<String> projectionFields = new ArrayList<String>();
        boolean wasIdExcluded = false;
        ArrayList<Tuple2<List<String>, Boolean>> projections = new ArrayList<Tuple2<List<String>, Boolean>>();
        for (String projectionKey : projectionObject.keySet()) {
            Object object = projectionObject.get(projectionKey);
            boolean included = false;
            boolean project = false;
            if (object instanceof Number) {
                included = ((Number)object).intValue() > 0;
            } else if (object instanceof Boolean) {
                included = (Boolean)object;
            } else if (object instanceof DBObject) {
                project = true;
                projectionFields.add(projectionKey);
            } else if (!object.toString().equals("text")) {
                String msg = "Projection `" + projectionKey + "' has a value that Fongo doesn't know how to handle: " + object + " (" + (object == null ? " " : object.getClass() + ")");
                throw new IllegalArgumentException(msg);
            }
            List<String> projectionPath = Util.split(projectionKey);
            if (!ID_KEY.equals(projectionKey)) {
                if (included) {
                    ++inclusionCount;
                } else if (!project) {
                    ++exclusionCount;
                }
            } else {
                boolean bl = wasIdExcluded = !included;
            }
            if (projectionPath.size() <= 0) continue;
            projections.add(new Tuple2<List<String>, Boolean>(projectionPath, included));
        }
        if (inclusionCount > 0 && exclusionCount > 0) {
            throw new IllegalArgumentException("You cannot combine inclusion and exclusion semantics in a single projection with the exception of the _id field: " + projectionObject);
        }
        if (exclusionCount > 0) {
            ret = (BasicDBObject)Util.clone(result);
        } else {
            ret = new BasicDBObject();
            if (!wasIdExcluded) {
                ret.append(ID_KEY, Util.clone(result.get(ID_KEY)));
            } else if (inclusionCount == 0) {
                ret = (BasicDBObject)Util.clone(result);
                ret.removeField(ID_KEY);
            }
        }
        for (Tuple2 tuple2 : projections) {
            if (((List)tuple2._1).size() == 1 && !((Boolean)tuple2._2).booleanValue()) {
                ret.removeField((String)((List)tuple2._1).get(0));
                continue;
            }
            FongoDBCollection.addValuesAtPath(ret, result, (List)tuple2._1, 0);
        }
        if (!projectionFields.isEmpty()) {
            for (String string : projectionObject.keySet()) {
                if (!projectionFields.contains(string)) continue;
                Object projectionValue = projectionObject.get(string);
                boolean isElemMatch = ((BasicDBObject)projectionObject.get(string)).containsField("$elemMatch");
                boolean isSlice = ((BasicDBObject)projectionObject.get(string)).containsField("$slice");
                if (isElemMatch) {
                    ret.removeField(string);
                    BasicDBList searchIn = (BasicDBList)result.get(string);
                    BasicDBObject searchFor = (BasicDBObject)((BasicDBObject)projectionObject.get(string)).get("$elemMatch");
                    String searchKey = (String)searchFor.keySet().toArray()[0];
                    int pos = -1;
                    int length = searchIn.size();
                    for (int i = 0; i < length; ++i) {
                        boolean matches;
                        ObjectId m2;
                        ObjectId m1;
                        BasicDBObject fieldToSearch = (BasicDBObject)searchIn.get(i);
                        if (!fieldToSearch.containsField(searchKey)) continue;
                        if (searchFor.get(searchKey) instanceof ObjectId && fieldToSearch.get(searchKey) instanceof String) {
                            m1 = new ObjectId(searchFor.get(searchKey).toString());
                            m2 = new ObjectId(String.valueOf(fieldToSearch.get(searchKey)));
                            matches = m1.equals((Object)m2);
                        } else if (searchFor.get(searchKey) instanceof String && fieldToSearch.get(searchKey) instanceof ObjectId) {
                            m1 = new ObjectId(String.valueOf(searchFor.get(searchKey)));
                            m2 = new ObjectId(fieldToSearch.get(searchKey).toString());
                            matches = m1.equals((Object)m2);
                        } else {
                            matches = fieldToSearch.get(searchKey).equals(searchFor.get(searchKey));
                        }
                        if (!matches) continue;
                        pos = i;
                        break;
                    }
                    if (pos == -1) continue;
                    BasicDBList append = new BasicDBList();
                    append.add(searchIn.get(pos));
                    ret.append(string, (Object)append);
                    LOG.debug("$elemMatch projection of field \"{}\", gave result: {} ({})", new Object[]{string, ret, ret.getClass()});
                    continue;
                }
                if (isSlice) {
                    FongoDBCollection.slice(result, projectionObject, string, projectionValue, ret);
                    continue;
                }
                String msg = "Projection `" + string + "' has a value that Fongo doesn't know how to handle: " + projectionValue + " (" + (projectionValue == null ? " " : projectionValue.getClass() + ")");
                throw new IllegalArgumentException(msg);
            }
        }
        return ret;
    }

    private static void slice(DBObject result, DBObject projectionObject, String projectionKey, Object projectionValue, BasicDBObject ret) throws MongoException {
        int limit;
        ret.removeField(projectionKey);
        BasicDBList searchIn = (BasicDBList)result.get(projectionKey);
        BasicDBObject basicDBObject = (BasicDBObject)projectionObject.get(projectionKey);
        int start = 0;
        if (basicDBObject.get("$slice") instanceof Number) {
            limit = ((Number)basicDBObject.get("$slice")).intValue();
            if (limit < 0) {
                start = limit;
                limit = -limit;
            }
        } else if (basicDBObject.get("$slice") instanceof List) {
            List range = (List)basicDBObject.get("$slice");
            if (range.size() != 2) {
                throw new IllegalArgumentException("$slice with an Array must have size of 2");
            }
            start = (Integer)range.get(0);
            limit = (Integer)range.get(1);
        } else {
            String msg = "Projection `" + projectionKey + "' has a value that Fongo doesn't know how to handle: " + projectionValue + " (" + (projectionValue == null ? " " : projectionValue.getClass() + ")");
            throw new IllegalArgumentException(msg);
        }
        if (limit < 0) {
            throw new MongoException("Can't canonicalize query: BadValue $slice limit must be positive");
        }
        BasicDBList slice = new BasicDBList();
        int startArray = start < 0 ? Math.max(0, searchIn.size() + start) + 1 : Math.min(searchIn.size(), start) + 1;
        int i = startArray;
        for (int count = 0; i <= searchIn.size() && count < limit; ++i, ++count) {
            slice.add(searchIn.get(i - 1));
        }
        ret.put(projectionKey, (Object)slice);
    }

    public Collection<DBObject> sortObjects(final DBObject orderby, Collection<DBObject> objects) {
        Collection<DBObject> objectsToSearch = objects;
        if (orderby != null) {
            final Set orderbyKeySet = orderby.keySet();
            if (!orderbyKeySet.isEmpty()) {
                DBObject[] objectsToSort = objects.toArray(new DBObject[objects.size()]);
                Arrays.sort(objectsToSort, new Comparator<DBObject>(){

                    @Override
                    public int compare(DBObject o1, DBObject o2) {
                        for (String sortKey : orderbyKeySet) {
                            List<String> path = Util.split(sortKey);
                            int sortDirection = (Integer)orderby.get(sortKey);
                            List<Object> o1list = FongoDBCollection.this.expressionParser.getEmbeddedValues(path, o1);
                            List<Object> o2list = FongoDBCollection.this.expressionParser.getEmbeddedValues(path, o2);
                            int compareValue = FongoDBCollection.this.expressionParser.compareLists(o1list, o2list) * sortDirection;
                            if (compareValue == 0) continue;
                            return compareValue;
                        }
                        return 0;
                    }
                });
                objectsToSearch = Arrays.asList(objectsToSort);
            }
        } else {
            objectsToSearch = this.sortObjects((DBObject)new BasicDBObject(FONGO_SPECIAL_ORDER_BY, (Object)1), objects);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("sorted objectsToSearch " + objectsToSearch);
        }
        return objectsToSearch;
    }

    public synchronized long getCount(DBObject query, DBObject fields, long limit, long skip) {
        Filter filter = (query = this.filterLists(query)) == null ? ExpressionParser.AllFilter : this.expressionParser.buildFilter(query);
        long count = 0L;
        long upperLimit = Long.MAX_VALUE;
        if (limit > 0L) {
            upperLimit = limit;
        }
        int seen = 0;
        Iterator<DBObject> iter = this.filterByIndexes(query).iterator();
        while (iter.hasNext() && count < upperLimit) {
            DBObject value = iter.next();
            if (!filter.apply(value) || (long)seen++ < skip) continue;
            ++count;
        }
        return count;
    }

    public synchronized long getCount(DBObject query, DBObject fields, ReadPreference readPrefs) {
        return this.getCount(query, fields, 0L, 0L);
    }

    public synchronized DBObject findAndModify(DBObject query, DBObject fields, DBObject sort, boolean remove, DBObject update, boolean returnNew, boolean upsert) {
        LOG.debug("findAndModify({}, {}, {}, {}, {}, {}, {}", new Object[]{query, fields, sort, remove, update, returnNew, upsert});
        query = this.filterLists(query);
        update = this.filterLists(update);
        Filter filter = this.expressionParser.buildFilter(query);
        Collection<DBObject> objectsToSearch = this.sortObjects(sort, this.filterByIndexes(query));
        DBObject beforeObject = null;
        DBObject afterObject = null;
        for (DBObject dbo : objectsToSearch) {
            if (!filter.apply(dbo)) continue;
            beforeObject = dbo;
            if (!remove) {
                afterObject = Util.clone(beforeObject);
                this.updateEngine.doUpdate(afterObject, update, query, false);
                this.addToIndexes(afterObject, beforeObject, this.getWriteConcern());
                break;
            }
            this.remove(dbo);
            return dbo;
        }
        if (beforeObject != null && !returnNew) {
            return this.replaceWithObjectClass(FongoDBCollection.applyProjections(beforeObject, fields));
        }
        if (beforeObject == null && upsert && !remove) {
            beforeObject = new BasicDBObject();
            afterObject = this.createUpsertObject(query);
            this.fInsert(this.updateEngine.doUpdate(afterObject, update, query, upsert), this.getWriteConcern());
        }
        DBObject resultObject = returnNew ? FongoDBCollection.applyProjections(afterObject, fields) : FongoDBCollection.applyProjections(beforeObject, fields);
        return this.replaceWithObjectClass(resultObject);
    }

    public synchronized List distinct(String key, DBObject query) {
        query = this.filterLists(query);
        LinkedHashSet<Object> results = new LinkedHashSet<Object>();
        Filter filter = this.expressionParser.buildFilter(query);
        for (DBObject value : this.filterByIndexes(query)) {
            if (!filter.apply(value)) continue;
            List<Object> keyValues = this.expressionParser.getEmbeddedValues(key, value);
            for (Object keyValue : keyValues) {
                if (keyValue instanceof List) {
                    results.addAll((List)keyValue);
                    continue;
                }
                results.add(keyValue);
            }
        }
        return new ArrayList(results);
    }

    public Cursor aggregate(List<DBObject> pipeline, AggregationOptions options, ReadPreference readPreference) {
        return this.createQueryResultIterator(this.aggregate(pipeline, readPreference).results().iterator());
    }

    public List<Cursor> parallelScan(ParallelScanOptions options) {
        return Arrays.asList(this.createQueryResultIterator(this._idIndex.values().iterator()));
    }

    BulkWriteResult executeBulkWriteOperation(boolean ordered, List<WriteRequest> requests, WriteConcern writeConcern, DBEncoder encoder) {
        Assertions.isTrue((String)"no operations", (!requests.isEmpty() ? 1 : 0) != 0);
        ArrayList<BulkWriteUpsert> upserts = new ArrayList<BulkWriteUpsert>();
        int insertedCount = 0;
        int matchedCount = 0;
        int removedCount = 0;
        int modifiedCount = 0;
        int idx = 0;
        for (WriteRequest request : requests) {
            switch (request.getType()) {
                case REPLACE: 
                case UPDATE: {
                    ModifyRequest r = (ModifyRequest)request;
                    WriteResult wr = this.update(r.getQuery(), r.getUpdateDocument(), r.isUpsert(), r.isMulti(), writeConcern, encoder);
                    matchedCount += wr.getN();
                    if (wr.isUpdateOfExisting()) {
                        upserts.add(new BulkWriteUpsert(idx, wr.getUpsertedId()));
                        break;
                    }
                    modifiedCount += wr.getN();
                    break;
                }
                case REMOVE: {
                    ModifyRequest r = (RemoveRequest)request;
                    WriteResult wr = this.remove(r.getQuery(), writeConcern, encoder);
                    matchedCount += wr.getN();
                    removedCount += wr.getN();
                    break;
                }
                case INSERT: {
                    ModifyRequest r = (InsertRequest)request;
                    WriteResult wr = this.insert(new DBObject[]{r.getDocument()});
                    insertedCount += wr.getN();
                    break;
                }
                default: {
                    throw new NotImplementedException();
                }
            }
            ++idx;
        }
        return new AcknowledgedBulkWriteResult(insertedCount, matchedCount, removedCount, Integer.valueOf(modifiedCount), upserts);
    }

    protected synchronized void _dropIndex(String name) throws MongoException {
        DBCollection indexColl = this.fongoDb.getCollection("system.indexes");
        indexColl.remove((DBObject)new BasicDBObject("name", (Object)name));
        ListIterator<IndexAbstract> iterator = this.indexes.listIterator();
        while (iterator.hasNext()) {
            IndexAbstract index = iterator.next();
            if (!index.getName().equals(name)) continue;
            iterator.remove();
            break;
        }
    }

    protected synchronized void _dropIndexes() {
        List indexes = this.fongoDb.getCollection("system.indexes").find().toArray();
        for (DBObject index : indexes) {
            String indexName = index.get("name").toString();
            if (ID_NAME_INDEX.equals(indexName)) continue;
            this.dropIndexes(indexName);
        }
    }

    public void drop() {
        this._idIndex.clear();
        this._dropIndexes();
        this.fongoDb.removeCollection(this);
    }

    private synchronized IndexAbstract searchIndex(DBObject query) {
        IndexAbstract result = null;
        int foundCommon = -1;
        Set queryFields = query.keySet();
        for (IndexAbstract index : this.indexes) {
            if (!index.canHandle(query) || index.getFields().size() <= foundCommon && (result == null || result.isUnique() || !index.isUnique())) continue;
            result = index;
            foundCommon = index.getFields().size();
        }
        LOG.debug("searchIndex() found index {} for fields {}", result, (Object)queryFields);
        return result;
    }

    private synchronized IndexAbstract searchGeoIndex(boolean unique) {
        IndexAbstract result = null;
        for (IndexAbstract index : this.indexes) {
            if (!index.isGeoIndex()) continue;
            if (result != null && unique) {
                this.fongoDb.notOkErrorResult(-5, "more than one 2d index, not sure which to run geoNear on").throwOnError();
            }
            result = index;
            if (unique) continue;
            break;
        }
        LOG.debug("searchGeoIndex() found index {}", result);
        return result;
    }

    private synchronized void addToIndexes(DBObject object, DBObject oldObject, WriteConcern concern) {
        this.fongoDb.addCollection(this);
        for (IndexAbstract index : this.indexes) {
            List<List<Object>> error = index.checkAddOrUpdate(object, oldObject);
            if (error.isEmpty()) continue;
            if (this.enforceDuplicates(concern)) {
                this.fongoDb.errorResult(11001, "E11000 duplicate key error index: " + this.getFullName() + "." + index.getName() + "  dup key : {" + error + " }").throwOnError();
            }
            return;
        }
        DBObject idFirst = Util.cloneIdFirst(object);
        Set oldQueryFields = oldObject == null ? Collections.emptySet() : oldObject.keySet();
        for (IndexAbstract index : this.indexes) {
            if (index.canHandle(object)) {
                index.addOrUpdate(idFirst, oldObject);
                continue;
            }
            if (!index.canHandle(oldObject)) continue;
            index.remove(oldObject);
        }
    }

    private synchronized void removeFromIndexes(DBObject object) {
        Set queryFields = object.keySet();
        for (IndexAbstract index : this.indexes) {
            if (!index.canHandle(object)) continue;
            index.remove(object);
        }
    }

    public synchronized Collection<IndexAbstract> getIndexes() {
        return Collections.unmodifiableList(this.indexes);
    }

    public synchronized List<DBObject> geoNear(DBObject near, DBObject query, Number limit, Number maxDistance, boolean spherical) {
        IndexAbstract matchingIndex = this.searchGeoIndex(true);
        if (matchingIndex == null) {
            this.fongoDb.notOkErrorResult(-5, "no geo indices for geoNear").throwOnError();
        }
        LOG.info("geoNear() near:{}, query:{}, limit:{}, maxDistance:{}, spherical:{}, use index:{}", new Object[]{near, query, limit, maxDistance, spherical, matchingIndex.getName()});
        List<LatLong> latLongs = GeoUtil.latLon(Collections.<String>emptyList(), near);
        return ((GeoIndex)matchingIndex).geoNear((DBObject)(query == null ? new BasicDBObject() : query), latLongs, limit == null ? 100 : limit.intValue(), spherical);
    }

    public synchronized DBObject text(String search, Number limit, DBObject project) {
        TextSearch ts = new TextSearch(this);
        return ts.findByTextSearch(search, (DBObject)(project == null ? new BasicDBObject() : project), limit == null ? 100 : limit.intValue());
    }

    private QueryResultIterator createQueryResultIterator(Iterator<DBObject> values) {
        try {
            QueryResultIterator iterator = new ObjenesisStd().getInstantiatorOf(QueryResultIterator.class).newInstance();
            Field field = QueryResultIterator.class.getDeclaredField("_cur");
            field.setAccessible(true);
            field.set(iterator, values);
            return iterator;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

