/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.impl.index;

import com.github.fakemongo.impl.Util;
import com.github.fakemongo.impl.index.GeoIndex;
import com.github.fakemongo.impl.index.HashedIndex;
import com.github.fakemongo.impl.index.Index;
import com.github.fakemongo.impl.index.IndexAbstract;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import java.util.Map;

public final class IndexFactory {
    private IndexFactory() {
    }

    public static IndexAbstract create(String name, DBObject keys, boolean unique) throws MongoException {
        String geoIndex = IndexFactory.getGeoKey(keys);
        if (geoIndex != null) {
            return new GeoIndex(name, keys, unique, geoIndex);
        }
        String hashed = IndexFactory.getHashedKey(keys);
        if (hashed != null) {
            return new HashedIndex(name, keys, unique, hashed);
        }
        return new Index(name, keys, unique);
    }

    private static String getHashedKey(DBObject keys) {
        String hashed = null;
        for (Map.Entry<String, Object> entry : Util.entrySet(keys)) {
            boolean localHashed;
            Object value = entry.getValue();
            if (!(value instanceof String) || !(localHashed = "hashed".equals(value))) continue;
            hashed = entry.getKey();
        }
        return hashed;
    }

    private static String getGeoKey(DBObject keys) {
        boolean first = true;
        String geo = null;
        for (Map.Entry<String, Object> entry : Util.entrySet(keys)) {
            Object value = entry.getValue();
            if (value instanceof String) {
                boolean localGeo;
                boolean bl = localGeo = "2d".equals(value) || "2dsphere".equals(value);
                if (localGeo) {
                    if (!first) {
                        throw new MongoException(13023, "2d has to be first in index");
                    }
                    geo = entry.getKey();
                }
            }
            first = false;
        }
        return geo;
    }
}

