/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.impl;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.gridfs.GridFSFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.LazyBSONObject;
import org.bson.LazyDBList;
import org.bson.types.Binary;

public final class Util {
    private Util() {
    }

    public static <T> BasicDBList list(T ... ts) {
        return Util.wrap(Arrays.asList(ts));
    }

    public static <T> T extractField(DBObject object, String field) {
        Object value;
        if (object == null) {
            return null;
        }
        int indexDot = field.indexOf(46);
        if (indexDot > 0) {
            String subField = field.substring(indexDot + 1);
            value = Util.extractField((DBObject)object.get(field.substring(0, indexDot)), subField);
        } else {
            value = object.get(field);
        }
        return (T)value;
    }

    public static boolean containsField(DBObject object, String field) {
        boolean result;
        if (object == null) {
            return false;
        }
        int indexDot = field.indexOf(46);
        if (indexDot > 0) {
            Object value;
            String subField = field.substring(indexDot + 1);
            String actualField = field.substring(0, indexDot);
            result = false;
            if (object.containsField(actualField) && (value = object.get(actualField)) instanceof DBObject) {
                result = Util.containsField((DBObject)value, subField);
            }
        } else {
            result = object.containsField(field);
        }
        return result;
    }

    public static void putValue(DBObject dbObject, String path, Object value) {
        if (dbObject == null) {
            return;
        }
        int indexDot = path.indexOf(46);
        if (indexDot > 0) {
            String field = path.substring(0, indexDot);
            String nextPath = path.substring(indexDot + 1);
            if (!dbObject.containsField(field)) {
                dbObject.put(field, (Object)new BasicDBObject());
            }
            Util.putValue((DBObject)dbObject.get(field), nextPath, value);
        } else {
            dbObject.put(path, value);
        }
    }

    public static BasicDBList wrap(List otherList) {
        BasicDBList list = new BasicDBList();
        list.addAll((Collection)otherList);
        return list;
    }

    public static List<String> split(String key) {
        int dot = 46;
        int index = key.indexOf(dot);
        if (index <= 0) {
            return Collections.singletonList(key);
        }
        ArrayList<String> path = new ArrayList<String>(5);
        while (index > 0) {
            path.add(key.substring(0, index));
            key = key.substring(index + 1);
            index = key.indexOf(dot);
        }
        path.add(key);
        return path;
    }

    public static boolean isPositiveInt(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static int compareToNullable(String s1, String s2) {
        if (s1 == null) {
            if (s2 == null) {
                return 0;
            }
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    public static Object clone(Object source) {
        if (source instanceof DBObject) {
            return Util.clone((DBObject)source);
        }
        if (source instanceof Binary) {
            return ((Binary)source).getData().clone();
        }
        return source;
    }

    public static <T extends DBObject> T clone(T source) {
        if (source == null) {
            return null;
        }
        if (source instanceof BasicDBObject) {
            DBObject clone = (DBObject)((BasicDBObject)source).copy();
            return (T)clone;
        }
        if (source instanceof BasicDBList) {
            DBObject clone = (DBObject)((BasicDBList)source).copy();
            return (T)clone;
        }
        if (source instanceof LazyDBList) {
            BasicDBList clone = new BasicDBList();
            for (Object o : (LazyDBList)source) {
                if (o instanceof DBObject) {
                    clone.add((Object)Util.clone((DBObject)o));
                    continue;
                }
                clone.add(o);
            }
            return (T)clone;
        }
        if (source instanceof LazyBSONObject) {
            BasicDBObject clone = new BasicDBObject();
            for (Map.Entry entry : ((LazyBSONObject)source).entrySet()) {
                if (entry.getValue() instanceof DBObject) {
                    clone.put((String)entry.getKey(), (Object)Util.clone((DBObject)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof Binary) {
                    clone.put((String)entry.getKey(), ((Binary)entry.getValue()).getData().clone());
                    continue;
                }
                clone.put((String)entry.getKey(), entry.getValue());
            }
            return (T)clone;
        }
        BasicDBObject clone = new BasicDBObject();
        for (Map.Entry<String, Object> entry : Util.entrySet(source)) {
            if (entry.getValue() instanceof DBObject) {
                clone.put(entry.getKey(), (Object)Util.clone((DBObject)entry.getValue()));
                continue;
            }
            if (entry.getValue() instanceof Binary) {
                clone.put(entry.getKey(), ((Binary)entry.getValue()).getData().clone());
                continue;
            }
            clone.put(entry.getKey(), entry.getValue());
        }
        return (T)clone;
    }

    public static Set<Map.Entry<String, Object>> entrySet(DBObject object) {
        return object.toMap().entrySet();
    }

    public static DBObject cloneIdFirst(DBObject source) {
        Set entrySet;
        if (source == null) {
            return null;
        }
        BasicDBObject newobj = new BasicDBObject();
        if (source.containsField("_id")) {
            newobj.put("_id", source.get("_id"));
        }
        if (source instanceof LazyBSONObject) {
            entrySet = ((LazyBSONObject)source).entrySet();
        } else if (source instanceof GridFSFile) {
            HashMap<String, Object> copyMap = new HashMap<String, Object>();
            for (String field : source.keySet()) {
                copyMap.put(field, source.get(field));
            }
            entrySet = copyMap.entrySet();
        } else {
            entrySet = source.toMap().entrySet();
        }
        for (Map.Entry entry : entrySet) {
            String field;
            field = (String)entry.getKey();
            if ("_id".equals(field)) continue;
            Object val = entry.getValue();
            if (val instanceof DBObject) {
                newobj.put(field, (Object)Util.clone((DBObject)val));
                continue;
            }
            newobj.put(field, Util.clone(val));
        }
        return newobj;
    }

    public static boolean isProjectionEmpty(DBObject projection) {
        return projection == null || projection.keySet().isEmpty();
    }
}

