/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.impl;

import com.github.fakemongo.Fongo;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.FongoDB;
import com.mongodb.FongoDBCollection;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapReduce {
    private static final Logger LOG = LoggerFactory.getLogger(MapReduce.class);
    private final Fongo fongo;
    private final FongoDB fongoDB;
    private final FongoDBCollection fongoDBCollection;
    private final String map;
    private final String reduce;
    private final String finalize;
    private final DBObject out;
    private final DBObject query;
    private final DBObject sort;
    private final int limit;

    public MapReduce(Fongo fongo, FongoDBCollection coll, String map, String reduce, String finalize, DBObject out, DBObject query, DBObject sort, Number limit) {
        this.fongo = fongo;
        this.fongoDB = out.containsField("db") ? (FongoDB)fongo.getDB((String)out.get("db")) : (FongoDB)coll.getDB();
        this.fongoDBCollection = coll;
        this.map = map;
        this.reduce = reduce;
        this.finalize = finalize;
        this.out = out;
        this.query = query;
        this.sort = sort;
        this.limit = limit == null ? 0 : limit.intValue();
    }

    public DBObject computeResult() {
        Outmode outmode = Outmode.valueFor(this.out);
        DBCollection coll = this.fongoDB.createCollection(outmode.collectionName(this.out), null);
        outmode.initCollection(coll);
        outmode.newResults(this, coll, this.runInContext());
        DBObject result = outmode.createResult(coll);
        LOG.debug("computeResult() : {}", (Object)result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DBObject> runInContext() {
        Context cx = Context.enter();
        try {
            ScriptableObject scope = cx.initStandardObjects();
            List objects = this.fongoDBCollection.find(this.query).sort(this.sort).limit(this.limit).toArray();
            List<String> javascriptFunctions = this.constructJavascriptFunction(objects);
            for (String jsFunction : javascriptFunctions) {
                try {
                    cx.evaluateString((Scriptable)scope, jsFunction, "<map-reduce>", 0, null);
                }
                catch (RhinoException e) {
                    LOG.error("Exception running script {}", (Object)jsFunction, (Object)e);
                    this.fongoDB.notOkErrorResult(16722, "JavaScript execution failed: " + e.getMessage()).throwOnError();
                }
            }
            NativeArray outs = (NativeArray)scope.get("$$$fongoOuts$$$", (Scriptable)scope);
            ArrayList<DBObject> dbOuts = new ArrayList<DBObject>();
            int i = 0;
            while ((long)i < outs.getLength()) {
                NativeObject out = (NativeObject)outs.get(i, (Scriptable)outs);
                dbOuts.add(this.getObject((ScriptableObject)out));
                ++i;
            }
            ArrayList<DBObject> arrayList = dbOuts;
            return arrayList;
        }
        finally {
            cx.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DBObject> reduceOutputStage(DBCollection coll, List<DBObject> mapReduceOutput) {
        Context cx = Context.enter();
        try {
            ScriptableObject scope = cx.initStandardObjects();
            List<String> jsFunctions = this.constructReduceOutputStageJavascriptFunction(coll, mapReduceOutput);
            for (String jsFunction : jsFunctions) {
                try {
                    cx.evaluateString((Scriptable)scope, jsFunction, "<reduce output stage>", 0, null);
                }
                catch (RhinoException e) {
                    LOG.error("Exception running script {}", (Object)jsFunction, (Object)e);
                    this.fongoDB.notOkErrorResult(16722, "JavaScript execution failed: " + e.getMessage()).throwOnError();
                }
            }
            NativeArray outs = (NativeArray)scope.get("$$$fongoOuts$$$", (Scriptable)scope);
            ArrayList<DBObject> dbOuts = new ArrayList<DBObject>();
            int i = 0;
            while ((long)i < outs.getLength()) {
                NativeObject out = (NativeObject)outs.get(i, (Scriptable)outs);
                dbOuts.add(this.getObject((ScriptableObject)out));
                ++i;
            }
            LOG.debug("reduceOutputStage() : {}", dbOuts);
            ArrayList<DBObject> arrayList = dbOuts;
            return arrayList;
        }
        finally {
            cx.exit();
        }
    }

    DBObject getObject(ScriptableObject no) {
        Object[] propIds;
        if (no instanceof NativeArray) {
            BasicDBList ret = new BasicDBList();
            NativeArray noArray = (NativeArray)no;
            int i = 0;
            while ((long)i < noArray.getLength()) {
                Object value = noArray.get(i, (Scriptable)noArray);
                if (value instanceof NativeObject || value instanceof NativeArray) {
                    value = this.getObject((ScriptableObject)value);
                }
                ret.add(value);
                ++i;
            }
            return ret;
        }
        BasicDBObject ret = new BasicDBObject();
        for (Object propId : propIds = no.getIds()) {
            String key = Context.toString((Object)propId);
            Object value = NativeObject.getProperty((Scriptable)no, (String)key);
            if (value instanceof NativeObject || value instanceof NativeArray) {
                value = this.getObject((ScriptableObject)value);
            }
            ret.put(key, value);
        }
        return ret;
    }

    private List<String> constructJavascriptFunction(List<DBObject> objects) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sb = new StringBuilder(80000);
        this.addMongoFunctions(sb);
        sb.append("var $$$fongoEmits$$$ = new Object();\n");
        sb.append("function emit(param1, param2) {\nvar toSource = param1.toSource();\nif(typeof $$$fongoEmits$$$[toSource] === 'undefined') {\n $$$fongoEmits$$$[toSource] = new Array();\n}\nvar val = {id: param1, value: param2};\n$$$fongoEmits$$$[toSource][$$$fongoEmits$$$[toSource].length] = val;\n};\n");
        sb.append("var fongoMapFunction = ").append(this.map).append(";\n");
        sb.append("var $$$fongoVars$$$ = new Object();\n");
        for (DBObject object : objects) {
            String json = JSON.serialize((Object)object);
            sb.append("$$$fongoVars$$$ = ").append(json).append(";\n");
            sb.append("$$$fongoVars$$$['fongoExecute'] = fongoMapFunction;\n");
            sb.append("$$$fongoVars$$$.fongoExecute();\n");
            if (sb.length() <= 65535) continue;
            result.add(sb.toString());
            sb.setLength(0);
        }
        result.add(sb.toString());
        sb.setLength(0);
        sb.append("var reduce = ").append(this.reduce).append("\n");
        sb.append("var $$$fongoOuts$$$ = Array();\nfor(var i in $$$fongoEmits$$$) {\nvar elem = $$$fongoEmits$$$[i];\nvalues = []; id = null; for (var ii in elem) { values.push(elem[ii].value); id = elem[ii].id;}\n$$$fongoOuts$$$[$$$fongoOuts$$$.length] = { _id : id, value : reduce(id, values) };\n}\n");
        result.add(sb.toString());
        return result;
    }

    private List<String> constructReduceOutputStageJavascriptFunction(DBCollection coll, List<DBObject> objects) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sb = new StringBuilder(80000);
        this.addMongoFunctions(sb);
        sb.append("var reduce = ").append(this.reduce).append("\n");
        sb.append("var $$$fongoOuts$$$ = new Array();\n");
        for (DBObject object : objects) {
            String objectJson = JSON.serialize((Object)object);
            String objectValueJson = JSON.serialize((Object)object.get("value"));
            DBObject existing = coll.findOne((DBObject)new BasicDBObject().append("_id", object.get("_id")));
            if (existing == null || existing.get("value") == null) {
                sb.append("$$$fongoOuts$$$[$$$fongoOuts$$$.length] = ").append(objectJson).append(";\n");
            } else {
                String id = JSON.serialize((Object)object.get("_id"));
                String existingValueJson = JSON.serialize((Object)existing.get("value"));
                sb.append("$$$fongoId$$$ = ").append(id).append(";\n");
                sb.append("$$$fongoValues$$$ = [ ").append(existingValueJson).append(", ").append(objectValueJson).append("];\n");
                sb.append("$$$fongoReduced$$$ = { _id : $$$fongoId$$$, value : reduce($$$fongoId$$$, $$$fongoValues$$$)};").append(";\n");
                sb.append("$$$fongoOuts$$$[$$$fongoOuts$$$.length] = $$$fongoReduced$$$;\n");
            }
            if (sb.length() <= 65535) continue;
            result.add(sb.toString());
            sb.setLength(0);
        }
        result.add(sb.toString());
        return result;
    }

    private void addMongoFunctions(StringBuilder construct) {
        construct.append("Array.sum = function(array) {\n    var a = 0;\n    for (var i = 0; i < array.length; i++) {\n        a = a + array[i];\n    }\n    return a;};\n");
    }

    private static enum Outmode {
        REPLACE{

            @Override
            public void initCollection(DBCollection coll) {
                coll.remove((DBObject)new BasicDBObject());
            }

            @Override
            public void newResults(MapReduce mr, DBCollection coll, List<DBObject> results) {
                coll.insert(results);
            }
        }
        ,
        MERGE{

            @Override
            public void newResults(MapReduce mr, DBCollection coll, List<DBObject> results) {
                for (DBObject result : results) {
                    coll.update((DBObject)new BasicDBObject("_id", result.get("_id")), result, true, false);
                }
            }
        }
        ,
        REDUCE{

            @Override
            public void newResults(MapReduce mr, DBCollection coll, List<DBObject> results) {
                List reduced = mr.reduceOutputStage(coll, results);
                for (DBObject result : reduced) {
                    coll.update((DBObject)new BasicDBObject("_id", result.get("_id")), result, true, false);
                }
            }
        }
        ,
        INLINE{

            @Override
            public void initCollection(DBCollection coll) {
                coll.remove((DBObject)new BasicDBObject());
            }

            @Override
            public void newResults(MapReduce mr, DBCollection coll, List<DBObject> results) {
                coll.insert(results);
            }

            @Override
            public String collectionName(DBObject object) {
                return UUID.randomUUID().toString();
            }

            @Override
            public DBObject createResult(DBCollection coll) {
                BasicDBList list = new BasicDBList();
                list.addAll((Collection)coll.find().toArray());
                return list;
            }
        };


        public static Outmode valueFor(DBObject object) {
            for (Outmode outmode : Outmode.values()) {
                if (!object.containsField(outmode.name().toLowerCase())) continue;
                return outmode;
            }
            return null;
        }

        public String collectionName(DBObject object) {
            return (String)object.get(this.name().toLowerCase());
        }

        public void initCollection(DBCollection coll) {
        }

        public abstract void newResults(MapReduce var1, DBCollection var2, List<DBObject> var3);

        public DBObject createResult(DBCollection coll) {
            BasicDBObject result = new BasicDBObject("collection", (Object)coll.getName()).append("db", (Object)coll.getDB().getName());
            return result;
        }
    }
}

