/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.impl.aggregation;

import com.github.fakemongo.impl.ExpressionParser;
import com.github.fakemongo.impl.aggregation.Group;
import com.github.fakemongo.impl.aggregation.PipelineKeyword;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lookup
extends PipelineKeyword {
    private static final Logger LOG = LoggerFactory.getLogger(Group.class);
    public static final Lookup INSTANCE = new Lookup();
    public static final String ID = "_id";

    @Override
    public DBCollection apply(DB originalDB, DBCollection parentColl, DBObject object) {
        DBObject lookup = ExpressionParser.toDbObject(object.get(this.getKeyword()));
        List<DBObject> parentItems = this.performLookup(originalDB, parentColl, lookup);
        return this.dropAndInsert(parentColl, parentItems);
    }

    @Override
    public String getKeyword() {
        return "$lookup";
    }

    private List<DBObject> performLookup(DB originalDB, DBCollection parentColl, DBObject lookup) {
        String from = (String)lookup.get("from");
        String localField = (String)lookup.get("localField");
        String foreignField = (String)lookup.get("foreignField");
        String as = (String)lookup.get("as");
        LOG.debug("Value {} will be returned from {} in parent collection {}.  Local field {} will be joined with {}", new Object[]{as, from, parentColl.getName(), localField, foreignField});
        DBCursor parentItems = parentColl.find();
        Iterator iterator = parentItems.iterator();
        HashMap<String, DBObject> parentMap = new HashMap<String, DBObject>();
        ArrayList<DBObject> parentsWithMissingLocalField = new ArrayList<DBObject>();
        while (iterator.hasNext()) {
            DBObject parentItem = (DBObject)iterator.next();
            String localFieldValue = (String)parentItem.get(localField);
            if (localFieldValue == null || "".equals(localField.trim())) {
                parentItem.put(as, new ArrayList());
                parentsWithMissingLocalField.add(parentItem);
                continue;
            }
            ArrayList childItems = (ArrayList)parentItem.get(as);
            if (childItems == null) {
                childItems = new ArrayList();
                parentItem.put(as, childItems);
            }
            parentMap.put(localFieldValue, parentItem);
        }
        DBCollection childColl = originalDB.getCollection(from);
        DBCursor childItems = childColl.find();
        for (DBObject childItem : childItems) {
            String parentOid = (String)childItem.get(foreignField);
            if (parentOid == null) {
                LOG.warn("Ignoring null parent id");
                continue;
            }
            DBObject parent = (DBObject)parentMap.get(parentOid);
            if (parent == null) {
                LOG.warn("Ignoring missing parent with id {}", (Object)parentOid);
                continue;
            }
            LOG.debug("Adding child with id {} to parent wth id {}", childItem.get(ID), (Object)parentOid);
            List childObjects = (List)parent.get(as);
            Assert.assertNotNull((String)"Unexpected null value", (Object)childObjects);
            childObjects.add(childItem);
        }
        ArrayList<DBObject> retval = new ArrayList<DBObject>();
        retval.addAll(parentMap.values());
        retval.addAll(parentsWithMissingLocalField);
        return retval;
    }
}

