/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo;

import com.github.fakemongo.FongoConnection;
import com.github.fakemongo.FongoConnectionSource;
import com.github.fakemongo.FongoException;
import com.mongodb.DB;
import com.mongodb.FongoBulkWriteCombiner;
import com.mongodb.FongoDB;
import com.mongodb.MockMongoClient;
import com.mongodb.MongoClient;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernResult;
import com.mongodb.binding.ConnectionSource;
import com.mongodb.binding.ReadBinding;
import com.mongodb.binding.WriteBinding;
import com.mongodb.bulk.DeleteRequest;
import com.mongodb.bulk.InsertRequest;
import com.mongodb.bulk.UpdateRequest;
import com.mongodb.bulk.WriteRequest;
import com.mongodb.client.MongoDatabase;
import com.mongodb.connection.ServerVersion;
import com.mongodb.internal.connection.NoOpSessionContext;
import com.mongodb.internal.session.ClientSessionContext;
import com.mongodb.operation.DeleteOperation;
import com.mongodb.operation.InsertOperation;
import com.mongodb.operation.MixedBulkWriteOperation;
import com.mongodb.operation.OperationExecutor;
import com.mongodb.operation.ReadOperation;
import com.mongodb.operation.UpdateOperation;
import com.mongodb.operation.WriteOperation;
import com.mongodb.session.ClientSession;
import com.mongodb.session.SessionContext;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bson.codecs.configuration.CodecRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fongo
implements OperationExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(Fongo.class);
    public static final ServerVersion V3_2_SERVER_VERSION = new ServerVersion(3, 2);
    public static final ServerVersion V3_3_SERVER_VERSION = new ServerVersion(3, 3);
    public static final ServerVersion V3_6_SERVER_VERSION = new ServerVersion(3, 6);
    public static final ServerVersion V3_SERVER_VERSION = new ServerVersion(3, 0);
    public static final ServerVersion OLD_SERVER_VERSION = new ServerVersion(0, 0);
    public static final ServerVersion DEFAULT_SERVER_VERSION = V3_6_SERVER_VERSION;
    private final Map<String, FongoDB> dbMap = new ConcurrentHashMap<String, FongoDB>();
    private final ServerAddress serverAddress;
    private final MongoClient mongo;
    private final String name;
    private final ServerVersion serverVersion;
    private final CodecRegistry codecRegistry;

    public Fongo(String name) {
        this(name, DEFAULT_SERVER_VERSION);
    }

    public Fongo(String name, ServerVersion serverVersion) {
        this(name, serverVersion, MongoClient.getDefaultCodecRegistry());
    }

    public Fongo(String name, ServerVersion serverVersion, CodecRegistry codecRegistry) {
        this.name = name;
        this.serverAddress = new ServerAddress(new InetSocketAddress(ServerAddress.defaultHost(), ServerAddress.defaultPort()));
        this.serverVersion = serverVersion;
        this.codecRegistry = codecRegistry;
        this.mongo = this.createMongo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FongoDB getDB(String dbname) {
        Map<String, FongoDB> map = this.dbMap;
        synchronized (map) {
            FongoDB fongoDb = this.dbMap.get(dbname);
            if (fongoDb == null) {
                fongoDb = new FongoDB(this, dbname);
                this.dbMap.put(dbname, fongoDb);
            }
            return fongoDb;
        }
    }

    public synchronized MongoDatabase getDatabase(String databaseName) {
        return this.mongo.getDatabase(databaseName);
    }

    public Collection<DB> getUsedDatabases() {
        return new ArrayList<DB>(this.dbMap.values());
    }

    public List<String> getDatabaseNames() {
        return new ArrayList<String>(this.dbMap.keySet());
    }

    public void dropDatabase(String dbName) {
        FongoDB db = this.dbMap.remove(dbName);
        if (db != null) {
            db.dropDatabase();
        }
    }

    public ServerAddress getServerAddress() {
        return this.serverAddress;
    }

    public MongoClient getMongo() {
        return this.mongo;
    }

    public WriteConcern getWriteConcern() {
        return this.mongo.getWriteConcern();
    }

    public ReadConcern getReadConcern() {
        return this.mongo.getReadConcern();
    }

    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    private MongoClient createMongo() {
        return MockMongoClient.create(this);
    }

    public <T> T execute(ReadOperation<T> operation, final ReadPreference readPreference, final ClientSession clientSession) {
        return (T)operation.execute(new ReadBinding(){

            public ReadPreference getReadPreference() {
                return readPreference;
            }

            public ConnectionSource getReadConnectionSource() {
                return new FongoConnectionSource(Fongo.this);
            }

            public SessionContext getSessionContext() {
                return clientSession == null ? NoOpSessionContext.INSTANCE : new ClientSessionContext(clientSession);
            }

            public ReadBinding retain() {
                return this;
            }

            public int getCount() {
                return 0;
            }

            public void release() {
            }
        });
    }

    public <T> T execute(WriteOperation<T> operation, final ClientSession clientSession) {
        if (operation instanceof MixedBulkWriteOperation) {
            MixedBulkWriteOperation mixedBulkWriteOperation = (MixedBulkWriteOperation)operation;
            FongoBulkWriteCombiner fongoBulkWriteCombiner = new FongoBulkWriteCombiner(mixedBulkWriteOperation.getWriteConcern());
            int i = 0;
            for (WriteRequest writeRequest : mixedBulkWriteOperation.getWriteRequests()) {
                WriteConcernResult update;
                if (writeRequest instanceof InsertRequest) {
                    InsertRequest insertRequest = (InsertRequest)writeRequest;
                    update = new FongoConnection(this).insert(mixedBulkWriteOperation.getNamespace(), mixedBulkWriteOperation.isOrdered(), insertRequest);
                    fongoBulkWriteCombiner.addInsertResult(update);
                } else if (writeRequest instanceof UpdateRequest) {
                    UpdateRequest updateRequest = (UpdateRequest)writeRequest;
                    update = new FongoConnection(this).update(mixedBulkWriteOperation.getNamespace(), mixedBulkWriteOperation.isOrdered(), updateRequest);
                    fongoBulkWriteCombiner.addUpdateResult(i, update);
                } else if (writeRequest instanceof DeleteRequest) {
                    DeleteRequest deleteRequest = (DeleteRequest)writeRequest;
                    update = new FongoConnection(this).delete(mixedBulkWriteOperation.getNamespace(), mixedBulkWriteOperation.isOrdered(), deleteRequest);
                    fongoBulkWriteCombiner.addRemoveResult(update);
                } else {
                    throw new FongoException("Fongo doesn't implement " + writeRequest.getClass());
                }
                ++i;
            }
            return (T)fongoBulkWriteCombiner.toBulkWriteResult();
        }
        if (operation instanceof UpdateOperation) {
            UpdateOperation updateOperation = (UpdateOperation)operation;
            FongoBulkWriteCombiner fongoBulkWriteCombiner = new FongoBulkWriteCombiner(updateOperation.getWriteConcern());
            int i = 0;
            for (UpdateRequest updateRequest : updateOperation.getUpdateRequests()) {
                WriteConcernResult update = new FongoConnection(this).update(updateOperation.getNamespace(), updateOperation.isOrdered(), updateRequest);
                fongoBulkWriteCombiner.addUpdateResult(i, update);
                ++i;
            }
            return (T)fongoBulkWriteCombiner.toWriteConcernResult();
        }
        if (operation instanceof InsertOperation) {
            InsertOperation insertOperation = (InsertOperation)operation;
            FongoBulkWriteCombiner fongoBulkWriteCombiner = new FongoBulkWriteCombiner(insertOperation.getWriteConcern());
            int i = 0;
            for (InsertRequest insertRequest : insertOperation.getInsertRequests()) {
                WriteConcernResult update = new FongoConnection(this).insert(insertOperation.getNamespace(), insertOperation.isOrdered(), insertRequest);
                fongoBulkWriteCombiner.addInsertResult(update);
                ++i;
            }
            return (T)fongoBulkWriteCombiner.toWriteConcernResult();
        }
        if (operation instanceof DeleteOperation) {
            DeleteOperation deleteOperation = (DeleteOperation)operation;
            FongoBulkWriteCombiner fongoBulkWriteCombiner = new FongoBulkWriteCombiner(deleteOperation.getWriteConcern());
            int i = 0;
            for (DeleteRequest deleteRequest : deleteOperation.getDeleteRequests()) {
                WriteConcernResult update = new FongoConnection(this).delete(deleteOperation.getNamespace(), deleteOperation.isOrdered(), deleteRequest);
                fongoBulkWriteCombiner.addRemoveResult(update);
                ++i;
            }
            return (T)fongoBulkWriteCombiner.toWriteConcernResult();
        }
        return (T)operation.execute(new WriteBinding(){

            public ConnectionSource getWriteConnectionSource() {
                return new FongoConnectionSource(Fongo.this);
            }

            public SessionContext getSessionContext() {
                return clientSession == null ? NoOpSessionContext.INSTANCE : new ClientSessionContext(clientSession);
            }

            public WriteBinding retain() {
                return this;
            }

            public int getCount() {
                return 0;
            }

            public void release() {
            }
        });
    }

    public String toString() {
        return "Fongo (" + this.name + ")";
    }

    public ServerVersion getServerVersion() {
        return this.serverVersion;
    }

    public <T> T execute(ReadOperation<T> operation, ReadPreference readPreference) {
        return this.execute(operation, readPreference, null);
    }

    public <T> T execute(WriteOperation<T> operation) {
        return this.execute(operation, null);
    }
}

