/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import com.jn.easyjson.core.JSONBuilderProvider;
import com.jn.easyjson.core.JsonTreeNode;
import com.jn.easyjson.core.node.JsonArrayNode;
import com.jn.easyjson.core.node.JsonNullNode;
import com.jn.easyjson.core.node.JsonObjectNode;
import com.jn.easyjson.core.node.JsonPrimitiveNode;
import com.jn.easyjson.core.node.JsonTreeNodes;
import com.jn.easyjson.core.node.ToJsonTreeNodeMapper;
import com.jn.easyjson.core.node.ToXxxJsonMapper;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.reflect.Reflects;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONString;

public class JsonMapper {
    private static final List<Class> supportedTypes = Collects.newArrayList((Object[])new Class[]{JSONObject.class, JSONArray.class, JSONString.class});

    public static JsonTreeNode toJsonTreeNode(Object object) {
        return JsonTreeNodes.toJsonTreeNode((Object)object, (ToJsonTreeNodeMapper)new ToJsonTreeNodeMapper(){

            public boolean isAcceptable(final @NonNull Object object) {
                return Collects.anyMatch((Collection)supportedTypes, (Predicate)new Predicate<Class>(){

                    public boolean test(Class value) {
                        return Reflects.isSubClassOrEquals((Class)value, object.getClass());
                    }
                });
            }

            public JsonTreeNode mapping(Object object) {
                if (object == JSONObject.NULL) {
                    return JsonNullNode.INSTANCE;
                }
                if (object instanceof JSONArray) {
                    JsonArrayNode array = new JsonArrayNode();
                    JSONArray jsonArray = (JSONArray)object;
                    for (Object item : jsonArray) {
                        array.add(JsonTreeNodes.toJsonTreeNode((Object)item, (ToJsonTreeNodeMapper)this));
                    }
                    return array;
                }
                if (object instanceof JSONObject) {
                    JsonObjectNode objectNode = new JsonObjectNode();
                    JSONObject obj = (JSONObject)object;
                    for (String key : obj.keySet()) {
                        objectNode.addProperty(key, JsonTreeNodes.toJsonTreeNode((Object)obj.get(key), (ToJsonTreeNodeMapper)this));
                    }
                    return objectNode;
                }
                String jsonString = null;
                if (object instanceof JSONString) {
                    jsonString = ((JSONString)object).toJSONString();
                }
                if (jsonString != null) {
                    return JSONBuilderProvider.simplest().fromJson(jsonString);
                }
                return null;
            }
        });
    }

    public static Object fromJsonTreeNode(JsonTreeNode node) {
        return JsonTreeNodes.toXxxJson((JsonTreeNode)node, (ToXxxJsonMapper)new ToXxxJsonMapper<JSONObject, JSONArray, Object, Object>(){

            public Object mappingNull(JsonNullNode node) {
                return JSONObject.NULL;
            }

            public Object mappingPrimitive(JsonPrimitiveNode node) {
                if (node.isBoolean()) {
                    return node.getAsBoolean();
                }
                if (node.isString()) {
                    return node.getAsString();
                }
                if (node.isNumber()) {
                    return node.getAsNumber();
                }
                return node.getValue();
            }

            public JSONArray mappingArray(JsonArrayNode arrayNode) {
                JSONArray array = new JSONArray();
                for (int i = 0; i < arrayNode.size(); ++i) {
                    array.put(JsonTreeNodes.toXxxJson((JsonTreeNode)arrayNode.get(i), (ToXxxJsonMapper)this));
                }
                return array;
            }

            public JSONObject mappingObject(JsonObjectNode node) {
                JsonObjectNode objectNode = node.getAsJsonObjectNode();
                Iterator iter = objectNode.propertySet().iterator();
                JSONObject map = new JSONObject();
                while (iter.hasNext()) {
                    Map.Entry entry = (Map.Entry)iter.next();
                    map.put((String)entry.getKey(), JsonTreeNodes.toXxxJson((JsonTreeNode)((JsonTreeNode)entry.getValue()), (ToXxxJsonMapper)this));
                }
                return map;
            }
        });
    }
}

