/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.asn1.spec;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.asn1.bytestring.ByteStringBuffer;
import com.jn.langx.asn1.spec.ASN1Element;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

public final class ASN1Writer {
    @NonNull
    private static final ThreadLocal<ByteStringBuffer> BUFFERS = new ThreadLocal();
    private static final int MAX_BUFFER_LENGTH = 524288;

    private ASN1Writer() {
    }

    public static void writeElement(@NonNull ASN1Element element, @NonNull OutputStream outputStream) throws IOException {
        ByteStringBuffer buffer = BUFFERS.get();
        if (buffer == null) {
            buffer = new ByteStringBuffer();
            BUFFERS.set(buffer);
        }
        element.encodeTo(buffer);
        try {
            buffer.write(outputStream);
        }
        finally {
            if (buffer.capacity() > 524288) {
                buffer.setCapacity(524288);
            }
            buffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeElement(@NonNull ASN1Element element, @NonNull ByteBuffer buffer) throws BufferOverflowException {
        ByteStringBuffer b = BUFFERS.get();
        if (b == null) {
            b = new ByteStringBuffer();
            BUFFERS.set(b);
        }
        element.encodeTo(b);
        try {
            if (buffer.remaining() < b.length()) {
                throw new BufferOverflowException();
            }
            int pos = buffer.position();
            buffer.put(b.getBackingArray(), 0, b.length());
            buffer.limit(buffer.position());
            buffer.position(pos);
        }
        finally {
            if (b.capacity() > 524288) {
                b.setCapacity(524288);
            }
            b.clear();
        }
    }
}

