/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.beans;

import com.jn.langx.annotation.Nullable;
import com.jn.langx.beans.BeansException;
import com.jn.langx.beans.CachedIntrospectionResults;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.reflect.Modifiers;
import com.jn.langx.util.reflect.Reflects;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JavaBeans {
    protected JavaBeans() {
    }

    public static Map<String, Object> toMap(Object bean) {
        PropertyDescriptor[] targetPropertyDescriptors;
        HashMap<String, Object> map = Collects.emptyHashMap(true);
        Preconditions.checkNotNull(bean, "bean must not be null");
        Class<?> actualEditable = bean.getClass();
        for (PropertyDescriptor targetPropertyDescriptor : targetPropertyDescriptors = JavaBeans.getPropertyDescriptors(actualEditable)) {
            Method readMethod = targetPropertyDescriptor.getReadMethod();
            if (readMethod == null) continue;
            String name = targetPropertyDescriptor.getName();
            try {
                if (!Modifiers.isPublic(readMethod.getDeclaringClass())) {
                    Reflects.makeAccessible(readMethod);
                }
                Object value = readMethod.invoke(bean, new Object[0]);
                map.put(name, value);
            }
            catch (Throwable ex) {
                throw new BeansException("Could not copy property '" + targetPropertyDescriptor.getName() + "' from source to map", ex);
            }
        }
        return map;
    }

    public static void copyProperties(Object source, Object target) throws BeansException {
        JavaBeans.copyProperties(source, target, null, (String[])null);
    }

    public static void copyProperties(Object source, Object target, Class<?> editable) throws BeansException {
        JavaBeans.copyProperties(source, target, editable, (String[])null);
    }

    public static void copyProperties(Object source, Object target, String ... ignoreProperties) throws BeansException {
        JavaBeans.copyProperties(source, target, null, ignoreProperties);
    }

    private static void copyProperties(Object source, Object target, Class<?> editable, String ... ignoreProperties) throws BeansException {
        Preconditions.checkNotNull(source, "Source must not be null");
        Preconditions.checkNotNull(target, "Target must not be null");
        Class<?> actualEditable = target.getClass();
        if (editable != null) {
            if (!editable.isInstance(target)) {
                String error = StringTemplates.formatWithPlaceholder("Target class [{}] not subclass or equals to Editable class [{}]", target.getClass().getName(), editable.getName());
                throw new IllegalArgumentException(error);
            }
            actualEditable = editable;
        }
        PropertyDescriptor[] targetPropertyDescriptors = JavaBeans.getPropertyDescriptors(actualEditable);
        List<String> ignoreList = ignoreProperties != null ? Arrays.asList(ignoreProperties) : null;
        for (PropertyDescriptor targetPropertyDescriptor : targetPropertyDescriptors) {
            Method readMethod;
            PropertyDescriptor sourcePropertyDescriptor;
            Method writeMethod = targetPropertyDescriptor.getWriteMethod();
            if (writeMethod == null || ignoreList != null && ignoreList.contains(targetPropertyDescriptor.getName()) || (sourcePropertyDescriptor = JavaBeans.getPropertyDescriptor(source.getClass(), targetPropertyDescriptor.getName())) == null || (readMethod = sourcePropertyDescriptor.getReadMethod()) == null || !Reflects.isSubClassOrEquals(writeMethod.getParameterTypes()[0], readMethod.getReturnType())) continue;
            try {
                if (!Modifiers.isPublic(readMethod.getDeclaringClass())) {
                    Reflects.makeAccessible(readMethod);
                }
                Object value = readMethod.invoke(source, new Object[0]);
                if (!Modifiers.isPublic(writeMethod.getDeclaringClass())) {
                    Reflects.makeAccessible(writeMethod);
                }
                writeMethod.invoke(target, value);
            }
            catch (Throwable ex) {
                throw new BeansException("Could not copy property '" + targetPropertyDescriptor.getName() + "' from source to target", ex);
            }
        }
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> clazz) throws BeansException {
        CachedIntrospectionResults cr = CachedIntrospectionResults.forClass(clazz);
        return cr.getPropertyDescriptors();
    }

    @Nullable
    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String propertyName) throws BeansException {
        return CachedIntrospectionResults.forClass(clazz).getPropertyDescriptor(propertyName);
    }
}

