/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.classpath.classloader;

import com.jn.langx.classpath.classloader.ClassLoaderAccessor;
import com.jn.langx.util.logging.Loggers;
import java.io.InputStream;
import org.slf4j.Logger;

public abstract class ExceptionIgnoringAccessor
implements ClassLoaderAccessor {
    @Override
    public Class loadClass(String fqcn) {
        Class<?> clazz;
        block3: {
            clazz = null;
            ClassLoader cl = this.getClassLoader();
            if (cl != null) {
                try {
                    clazz = Class.forName(fqcn, false, cl);
                }
                catch (ClassNotFoundException e) {
                    Logger log = Loggers.getLogger(ExceptionIgnoringAccessor.class);
                    if (!log.isTraceEnabled()) break block3;
                    log.trace("Unable to load clazz named [" + fqcn + "] from class loader [" + cl + "]");
                }
            }
        }
        return clazz;
    }

    @Override
    public InputStream getResourceStream(String name) {
        InputStream is = null;
        ClassLoader cl = this.getClassLoader();
        if (cl != null) {
            is = cl.getResourceAsStream(name);
        }
        return is;
    }

    protected final ClassLoader getClassLoader() {
        try {
            return this.doGetClassLoader();
        }
        catch (Throwable t) {
            Logger log = Loggers.getLogger(ExceptionIgnoringAccessor.class);
            if (log.isDebugEnabled()) {
                log.debug("Unable to acquire ClassLoader.", t);
            }
            return null;
        }
    }

    protected abstract ClassLoader doGetClassLoader() throws Throwable;
}

