/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.classpath.cp;

import com.jn.langx.classpath.Classpaths;
import com.jn.langx.classpath.cp.AbstractClasspath;
import com.jn.langx.io.resource.Location;
import com.jn.langx.io.resource.Locations;
import com.jn.langx.io.resource.Resource;
import com.jn.langx.io.resource.ResourceNotFoundException;
import com.jn.langx.io.resource.Resources;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Supplier;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.io.file.Filenames;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarFileClasspath
extends AbstractClasspath {
    private Map<String, Set<String>> fileEntries = Collects.emptyNonAbsentHashMap(new Supplier<String, Set<String>>(){

        @Override
        public Set<String> get(String key) {
            return Collects.emptyHashSet();
        }
    });
    private String jarfileURL;
    private Location root;

    private String getSuffix(String path) {
        String suffix = Filenames.getSuffix(path);
        return Emptys.isNotEmpty(suffix) ? suffix : "__langx_other__";
    }

    public JarFileClasspath(String jarPath) {
        this(new File(jarPath));
    }

    public JarFileClasspath(File file) {
        if (file.exists() && file.isFile() && file.canRead()) {
            JarFile jarfile = null;
            try {
                jarfile = new JarFile(file);
                for (JarEntry entry : Collections.list(jarfile.entries())) {
                    if (entry.isDirectory()) continue;
                    String suffix = this.getSuffix(entry.getName());
                    this.fileEntries.get(suffix).add(entry.getName());
                }
                this.jarfileURL = file.getCanonicalFile().toURI().toURL().toString();
            }
            catch (IOException e) {
                try {
                    throw new ResourceNotFoundException(file.getName());
                }
                catch (Throwable throwable) {
                    IOs.close(jarfile);
                    throw throwable;
                }
            }
            IOs.close(jarfile);
        }
        this.root = new Location("jar:", this.jarfileURL + "!/");
    }

    @Override
    public Resource findResource(String relativePath) {
        relativePath = Classpaths.getCanonicalFilePath(relativePath);
        String suffix = this.getSuffix(relativePath);
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        if (this.fileEntries.get(suffix).contains(relativePath)) {
            String url = this.getUrl(relativePath);
            return Resources.loadUrlResource(url);
        }
        return null;
    }

    @Override
    public Location getRoot() {
        return this.root;
    }

    @Override
    public Set<Location> allResources() {
        return Pipeline.of(this.fileEntries).flatMap(new Function<String, Location>(){

            @Override
            public Location apply(String relativePath) {
                relativePath = Classpaths.getCanonicalFilePath(relativePath);
                return Locations.newLocation(JarFileClasspath.this.root, relativePath);
            }
        }).asSet(false);
    }

    private String getUrl(String relativePath) {
        relativePath = Classpaths.getCanonicalFilePath(relativePath);
        return this.root.getLocation() + relativePath;
    }
}

