/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.configuration.resource;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.configuration.AbstractConfigurationLoader;
import com.jn.langx.configuration.Configuration;
import com.jn.langx.configuration.InputStreamConfigurationParser;
import com.jn.langx.io.resource.Location;
import com.jn.langx.io.resource.ResourceLocationProvider;
import com.jn.langx.io.resource.Resources;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.logging.Loggers;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;

public class ResourceConfigurationLoader<T extends Configuration>
extends AbstractConfigurationLoader<T> {
    private InputStreamConfigurationParser<T> parser;
    private ResourceLocationProvider<String> resourceLocationProvider;

    public InputStreamConfigurationParser<T> getParser() {
        return this.parser;
    }

    public void setParser(InputStreamConfigurationParser<T> parser) {
        this.parser = parser;
    }

    public ResourceLocationProvider<String> getResourceLocationProvider() {
        return this.resourceLocationProvider;
    }

    public void setResourceLocationProvider(ResourceLocationProvider<String> resourceLocationProvider) {
        this.resourceLocationProvider = resourceLocationProvider;
    }

    @Override
    public T load(@NonNull String configurationId) {
        Preconditions.checkNotEmpty(configurationId, "the configuration id is null or empty");
        Location location = this.resourceLocationProvider.get(configurationId);
        Preconditions.checkNotNull(location, "Can't find the location for configuration : {}", configurationId);
        Configuration configuration = null;
        Object resource = Resources.loadResource(location);
        Logger logger = Loggers.getLogger(this.getClass());
        if (resource != null && resource.exists()) {
            InputStream inputStream = null;
            try {
                inputStream = resource.getInputStream();
                configuration = (Configuration)this.parser.parse(inputStream);
                if (configuration != null) {
                    configuration.setId(configurationId);
                }
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        } else {
            logger.error("Location {} is not exists", (Object)location);
        }
        return null;
    }
}

