/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.distributed.cluster.loadbalance;

import com.jn.langx.distributed.cluster.loadbalance.AbstractLoadBalanceStrategy;
import com.jn.langx.distributed.cluster.loadbalance.Node;
import com.jn.langx.util.random.ThreadLocalRandom;
import java.util.List;

public class RandomLoadBalanceStrategy<NODE extends Node, INVOCATION>
extends AbstractLoadBalanceStrategy<NODE, INVOCATION> {
    public RandomLoadBalanceStrategy() {
        this.setName("Random");
    }

    @Override
    protected NODE doSelect(List<NODE> aliveNodes, INVOCATION invocation) {
        int length = aliveNodes.size();
        boolean sameWeight = true;
        int[] weights = new int[length];
        int totalWeight = 0;
        for (int i = 0; i < length; ++i) {
            int weight = this.getWeight((Node)aliveNodes.get(i), invocation);
            weights[i] = totalWeight += weight;
            if (!sameWeight || totalWeight == weight * (i + 1)) continue;
            sameWeight = false;
        }
        if (totalWeight > 0 && !sameWeight) {
            int offset = ThreadLocalRandom.current().nextInt(totalWeight);
            for (int i = 0; i < length; ++i) {
                if (offset >= weights[i]) continue;
                return (NODE)((Node)aliveNodes.get(i));
            }
        }
        return (NODE)((Node)aliveNodes.get(ThreadLocalRandom.current().nextInt(length)));
    }
}

