/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.lifecycle;

import com.jn.langx.event.EventListener;
import com.jn.langx.event.EventPublisher;
import com.jn.langx.event.EventPublisherAware;
import com.jn.langx.lifecycle.State;
import com.jn.langx.lifecycle.StatefulEventListener;
import com.jn.langx.lifecycle.StatefulLifecycle;
import com.jn.langx.util.Strings;
import com.jn.langx.util.Throwables;
import com.jn.langx.util.concurrent.lock.AutoLock;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.os.Uptime;
import java.util.List;
import org.slf4j.Logger;

public abstract class AbstractStatefulLifecycle
implements StatefulLifecycle,
EventPublisherAware {
    private static final Logger logger = Loggers.getLogger(AbstractStatefulLifecycle.class);
    private String domain;
    private EventPublisher publisher;
    private final AutoLock lock = new AutoLock();
    private volatile State state = State.STOPPED;

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    @Override
    public EventPublisher getEventPublisher() {
        return this.publisher;
    }

    @Override
    public void setEventPublisher(EventPublisher publisher) {
        this.publisher = publisher;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void startup() {
        AutoLock l = null;
        try {
            l = this.lock.lock();
            try {
                switch (this.state) {
                    case STARTED: {
                        return;
                    }
                    case STARTING: 
                    case STOPPING: {
                        throw new IllegalStateException(this.getState().name());
                    }
                }
                try {
                    this.setStarting();
                    this.doStart();
                    this.setStarted();
                    return;
                }
                catch (StopException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Unable to stop", (Throwable)e);
                    }
                    this.setStopping();
                    this.doStop();
                    this.setStopped();
                    return;
                }
            }
            catch (Throwable e) {
                this.setFailed(e);
                throw Throwables.wrapAsRuntimeException(e);
            }
        }
        finally {
            IOs.close(l);
        }
    }

    @Override
    public final void shutdown() {
        AutoLock l = null;
        try {
            l = this.lock.lock();
            try {
                switch (this.state) {
                    case STOPPED: {
                        break;
                    }
                    case STARTING: 
                    case STOPPING: {
                        throw new IllegalStateException(this.getState().name());
                    }
                    default: {
                        this.setStopping();
                        this.doStop();
                        this.setStopped();
                        break;
                    }
                }
            }
            catch (Throwable e) {
                this.setFailed(e);
                throw Throwables.wrapAsRuntimeException(e);
            }
        }
        finally {
            IOs.close(l);
        }
    }

    @Override
    public boolean isRunning() {
        return this.state == State.STARTED || this.state == State.STARTING;
    }

    @Override
    public boolean isStarted() {
        return this.state == State.STARTED;
    }

    @Override
    public boolean isStarting() {
        return this.state == State.STARTING;
    }

    @Override
    public boolean isStopping() {
        return this.state == State.STOPPING;
    }

    @Override
    public boolean isStopped() {
        return this.state == State.STOPPED;
    }

    @Override
    public boolean isFailed() {
        return this.state == State.FAILED;
    }

    @Override
    public void addEventListener(EventListener listener) {
        this.publisher.addEventListener(this.domain, listener);
    }

    @Override
    public void removeEventListener(EventListener listener) {
        this.publisher.removeEventListener(this.domain, listener);
    }

    public State getState() {
        return this.state;
    }

    public static State getState(StatefulLifecycle lc) {
        if (lc instanceof AbstractStatefulLifecycle) {
            return ((AbstractStatefulLifecycle)lc).state;
        }
        if (lc.isStarting()) {
            return State.STARTING;
        }
        if (lc.isStarted()) {
            return State.STARTED;
        }
        if (lc.isStopping()) {
            return State.STOPPING;
        }
        if (lc.isStopped()) {
            return State.STOPPED;
        }
        return State.FAILED;
    }

    private void setStarted() {
        if (this.state == State.STARTING) {
            this.state = State.STARTED;
            if (logger.isDebugEnabled()) {
                logger.debug("STARTED @{}ms {}", (Object)Uptime.getUptime(), (Object)this);
            }
            List<EventListener> listeners = this.publisher.getListeners(this.domain);
            for (EventListener listener : listeners) {
                if (!(listener instanceof StatefulEventListener)) continue;
                ((StatefulEventListener)listener).lifecycleStarted(this);
            }
        }
    }

    private void setStarting() {
        if (logger.isDebugEnabled()) {
            logger.debug("STARTING {}", (Object)this);
        }
        this.state = State.STARTING;
        List<EventListener> listeners = this.publisher.getListeners(this.domain);
        for (EventListener listener : listeners) {
            if (!(listener instanceof StatefulEventListener)) continue;
            ((StatefulEventListener)listener).lifecycleStarting(this);
        }
    }

    private void setStopping() {
        if (logger.isDebugEnabled()) {
            logger.debug("STOPPING {}", (Object)this);
        }
        this.state = State.STOPPING;
        List<EventListener> listeners = this.publisher.getListeners(this.domain);
        for (EventListener listener : listeners) {
            if (!(listener instanceof StatefulEventListener)) continue;
            ((StatefulEventListener)listener).lifecycleStopping(this);
        }
    }

    private void setStopped() {
        if (this.state == State.STOPPING) {
            this.state = State.STOPPED;
            if (logger.isDebugEnabled()) {
                logger.debug("STOPPED {}", (Object)this);
            }
            List<EventListener> listeners = this.publisher.getListeners(this.domain);
            for (EventListener listener : listeners) {
                if (!(listener instanceof StatefulEventListener)) continue;
                ((StatefulEventListener)listener).lifecycleStopped(this);
            }
        }
    }

    private void setFailed(Throwable th) {
        this.state = State.FAILED;
        if (logger.isDebugEnabled()) {
            logger.warn("FAILED {}: {}", new Object[]{this, th, th});
        }
        List<EventListener> listeners = this.publisher.getListeners(this.domain);
        for (EventListener listener : listeners) {
            if (!(listener instanceof StatefulEventListener)) continue;
            ((StatefulEventListener)listener).lifecycleFailure(this, th);
        }
    }

    public String toString() {
        String name = this.getClass().getSimpleName();
        if (Strings.isBlank(name) && this.getClass().getSuperclass() != null) {
            name = this.getClass().getSuperclass().getSimpleName();
        }
        return String.format("%s@%x{%s}", new Object[]{name, this.hashCode(), this.getState()});
    }

    public class StopException
    extends RuntimeException {
    }
}

