/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.management;

import com.jn.langx.annotation.Singleton;
import com.jn.langx.management.MBeanService;
import com.jn.langx.registry.AbstractRegistry;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.reflect.Reflects;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

@Singleton
public class MBeanServiceProvider
extends AbstractRegistry<Class, MBeanService> {
    private static MBeanServiceProvider INSTANCE;

    private MBeanServiceProvider() {
        super(new ConcurrentHashMap());
    }

    @Override
    public void register(MBeanService mBeanService) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MBeanServiceProvider getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<MBeanServiceProvider> clazz = MBeanServiceProvider.class;
        synchronized (MBeanServiceProvider.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new MBeanServiceProvider();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S extends MBeanService> S getService(Class<S> serviceClazz, ClassLoader classLoader) {
        if (serviceClazz == null) {
            return null;
        }
        MBeanService service = (MBeanService)INSTANCE.get(serviceClazz);
        if (service != null && Reflects.isSubClassOrEquals(serviceClazz, service.getClass())) {
            return (S)service;
        }
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            if (classLoader != null) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            ServiceLoader<S> loader = ServiceLoader.load(serviceClazz);
            Iterator<S> iter = loader.iterator();
            Logger logger = Loggers.getLogger(MBeanServiceProvider.class);
            while (iter.hasNext()) {
                MBeanService mBeanService;
                try {
                    MBeanService svc = (MBeanService)iter.next();
                    if (!svc.isServiceMatch()) continue;
                    INSTANCE.register(serviceClazz, svc);
                    mBeanService = svc;
                }
                catch (Throwable ex) {
                    logger.warn("Exception occured when get the service [" + serviceClazz + "]", ex);
                    continue;
                }
                return (S)mBeanService;
            }
            logger.warn("Can't find the service [" + serviceClazz + "]");
        }
        finally {
            if (classLoader != null) {
                Thread.currentThread().setContextClassLoader(originalCL);
            }
        }
        return null;
    }
}

