/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.crypto.cipher;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.NotEmpty;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.exception.IllegalParameterException;
import com.jn.langx.security.SecurityException;
import com.jn.langx.security.Securitys;
import com.jn.langx.security.crypto.CryptoException;
import com.jn.langx.security.crypto.cipher.AlgorithmParameterSupplier;
import com.jn.langx.security.crypto.cipher.CipherAlgorithmSuite;
import com.jn.langx.security.crypto.cipher.CipherAlgorithmSuiteRegistry;
import com.jn.langx.security.crypto.cipher.DefaultAlgorithmParameterSupplier;
import com.jn.langx.security.crypto.cipher.Symmetrics;
import com.jn.langx.security.crypto.key.supplier.bytesbased.BytesBasedKeySupplier;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.enums.Enums;
import com.jn.langx.util.logging.Loggers;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;

public class Ciphers
extends Securitys {
    private static final CipherAlgorithmSuiteRegistry ALGORITHM_SUITE_REGISTRY = new CipherAlgorithmSuiteRegistry();

    protected Ciphers() {
    }

    public static String getDefaultTransformation(String algorithm) {
        return ALGORITHM_SUITE_REGISTRY.getTransformation(algorithm);
    }

    public static void addDefaultTransformation(String algorithm, String transformation) {
        ALGORITHM_SUITE_REGISTRY.add(algorithm, transformation);
    }

    public static Cipher createEmptyCipher(@NonNull String algorithmTransformation, @Nullable Provider provider) {
        try {
            Cipher cipher = provider == null ? Cipher.getInstance(algorithmTransformation) : Cipher.getInstance(algorithmTransformation, provider);
            return cipher;
        }
        catch (Throwable ex) {
            throw new SecurityException(ex.getMessage(), ex);
        }
    }

    public static Cipher createCipher(@NonNull String algorithmTransformation, @Nullable Provider provider, int operateMode, Key key, SecureRandom secureRandom) {
        try {
            Cipher cipher = Ciphers.createEmptyCipher(algorithmTransformation, provider);
            if (secureRandom == null) {
                cipher.init(operateMode, key);
            } else {
                cipher.init(operateMode, key, secureRandom);
            }
            return cipher;
        }
        catch (Throwable ex) {
            throw new SecurityException(ex.getMessage(), ex);
        }
    }

    public static Cipher createCipher(@NonNull String algorithmTransformation, @Nullable Provider provider, int operateMode, Key key, @Nullable AlgorithmParameterSpec parameterSpec, SecureRandom secureRandom) {
        try {
            Cipher cipher = Ciphers.createEmptyCipher(algorithmTransformation, provider);
            if (secureRandom == null) {
                cipher.init(operateMode, key, parameterSpec);
            } else {
                cipher.init(operateMode, key, parameterSpec, secureRandom);
            }
            return cipher;
        }
        catch (Throwable ex) {
            throw new SecurityException(ex.getMessage(), ex);
        }
    }

    public static Cipher createCipher(@NonNull String algorithmTransformation, @Nullable Provider provider, int operateMode, Key key, @Nullable AlgorithmParameters parameters, SecureRandom secureRandom) {
        try {
            Cipher cipher = Ciphers.createEmptyCipher(algorithmTransformation, provider);
            if (secureRandom == null) {
                if (parameters != null) {
                    cipher.init(operateMode, key, parameters);
                } else {
                    cipher.init(operateMode, key);
                }
            } else if (parameters != null) {
                cipher.init(operateMode, key, parameters, secureRandom);
            } else {
                cipher.init(operateMode, key, secureRandom);
            }
            return cipher;
        }
        catch (Throwable ex) {
            throw new SecurityException(ex.getMessage(), ex);
        }
    }

    public static Cipher createCipher(@NonNull String algorithmTransformation, @Nullable Provider provider, int operateMode, Certificate certificate, SecureRandom secureRandom) {
        try {
            Cipher cipher = Ciphers.createEmptyCipher(algorithmTransformation, provider);
            if (secureRandom == null) {
                cipher.init(operateMode, certificate);
            } else {
                cipher.init(operateMode, certificate, secureRandom);
            }
            return cipher;
        }
        catch (Throwable ex) {
            throw new SecurityException(ex.getMessage(), ex);
        }
    }

    public static byte[] encrypt(Cipher cipher, byte[] data) {
        try {
            return cipher.doFinal(data);
        }
        catch (Throwable ex) {
            throw new CryptoException(ex.getMessage(), ex);
        }
    }

    public static byte[] decrypt(Cipher cipher, byte[] data) {
        try {
            return cipher.doFinal(data);
        }
        catch (Throwable ex) {
            throw new CryptoException(ex.getMessage(), ex);
        }
    }

    public static byte[] encrypt(byte[] bytes, byte[] keyBytes, String algorithm, String algorithmTransformation, Provider provider, SecureRandom secureRandom, @NonNull BytesBasedKeySupplier keySupplier) {
        return Ciphers.doEncryptOrDecrypt(bytes, keyBytes, algorithm, algorithmTransformation, provider, secureRandom, keySupplier, true);
    }

    public static byte[] encrypt(byte[] bytes, byte[] keyBytes, String algorithm, String algorithmTransformation, Provider provider, SecureRandom secureRandom, @NonNull BytesBasedKeySupplier keySupplier, @Nullable AlgorithmParameterSpec parameterSpec) {
        return Ciphers.doEncryptOrDecrypt(bytes, keyBytes, algorithm, algorithmTransformation, provider, secureRandom, keySupplier, parameterSpec, true);
    }

    public static byte[] encrypt(byte[] bytes, byte[] keyBytes, String algorithm, String algorithmTransformation, Provider provider, SecureRandom secureRandom, @NonNull BytesBasedKeySupplier keySupplier, final @Nullable AlgorithmParameters parameters) {
        return Ciphers.encrypt(bytes, keyBytes, algorithm, algorithmTransformation, provider, secureRandom, keySupplier, parameters == null ? null : new AlgorithmParameterSupplier(){

            @Override
            public Object get(Key key, String algorithm, String transform, Provider provider, SecureRandom secureRandom) {
                return parameters;
            }
        });
    }

    public static byte[] encrypt(byte[] bytes, byte[] keyBytes, String algorithm, String algorithmTransformation, Provider provider, SecureRandom secureRandom, @NonNull BytesBasedKeySupplier keySupplier, @Nullable AlgorithmParameterSupplier parameterSupplier) {
        return Ciphers.doEncryptOrDecrypt(bytes, keyBytes, algorithm, algorithmTransformation, provider, secureRandom, keySupplier, parameterSupplier, true);
    }

    public static byte[] decrypt(byte[] bytes, byte[] keyBytes, String algorithm, String algorithmTransformation, Provider provider, SecureRandom secureRandom, @NonNull BytesBasedKeySupplier keySupplier) {
        return Ciphers.doEncryptOrDecrypt(bytes, keyBytes, algorithm, algorithmTransformation, provider, secureRandom, keySupplier, false);
    }

    public static byte[] decrypt(byte[] bytes, byte[] keyBytes, String algorithm, String algorithmTransformation, Provider provider, SecureRandom secureRandom, @NonNull BytesBasedKeySupplier keySupplier, @Nullable AlgorithmParameterSpec parameterSpec) {
        return Ciphers.doEncryptOrDecrypt(bytes, keyBytes, algorithm, algorithmTransformation, provider, secureRandom, keySupplier, parameterSpec, false);
    }

    public static byte[] decrypt(byte[] bytes, byte[] keyBytes, String algorithm, String algorithmTransformation, Provider provider, SecureRandom secureRandom, @NonNull BytesBasedKeySupplier keySupplier, final @Nullable AlgorithmParameters parameters) {
        return Ciphers.decrypt(bytes, keyBytes, algorithm, algorithmTransformation, provider, secureRandom, keySupplier, parameters == null ? null : new AlgorithmParameterSupplier(){

            @Override
            public Object get(Key key, String algorithm, String transform, Provider provider, SecureRandom secureRandom) {
                return parameters;
            }
        });
    }

    public static byte[] decrypt(byte[] bytes, byte[] keyBytes, String algorithm, String algorithmTransformation, Provider provider, SecureRandom secureRandom, @NonNull BytesBasedKeySupplier keySupplier, @Nullable AlgorithmParameterSupplier parameterSupplier) {
        return Ciphers.doEncryptOrDecrypt(bytes, keyBytes, algorithm, algorithmTransformation, provider, secureRandom, keySupplier, parameterSupplier, false);
    }

    public static byte[] doEncryptOrDecrypt(byte[] bytes, byte[] keyBytes, String algorithm, String algorithmTransformation, Provider provider, SecureRandom secureRandom, @NonNull BytesBasedKeySupplier keySupplier, boolean encrypt) {
        return Ciphers.doEncryptOrDecrypt(bytes, keyBytes, algorithm, algorithmTransformation, provider, secureRandom, keySupplier, (AlgorithmParameterSpec)null, encrypt);
    }

    public static byte[] doEncryptOrDecrypt(byte[] bytes, byte[] keyBytes, String algorithm, String algorithmTransformation, Provider provider, SecureRandom secureRandom, @NonNull BytesBasedKeySupplier keySupplier, final @Nullable AlgorithmParameterSpec parameterSpec, boolean encrypt) {
        return Ciphers.doEncryptOrDecrypt(bytes, keyBytes, algorithm, algorithmTransformation, provider, secureRandom, keySupplier, parameterSpec == null ? null : new AlgorithmParameterSupplier(){

            @Override
            public Object get(Key key, String algorithm, String transform, Provider provider, SecureRandom secureRandom) {
                return parameterSpec;
            }
        }, encrypt);
    }

    public static byte[] doEncryptOrDecrypt(byte[] bytes, byte[] keyBytes, String algorithm, String algorithmTransformation, Provider provider, SecureRandom secureRandom, @NonNull BytesBasedKeySupplier keySupplier, @Nullable AlgorithmParameterSupplier parameterSupplier, boolean encrypt) {
        Preconditions.checkNotEmpty(keyBytes, "{} key is empty", algorithm);
        Preconditions.checkArgument(!Emptys.isAllEmpty(algorithm, algorithmTransformation), "the algorithm and algorithmTransformation is empty");
        Preconditions.checkNotNull(keySupplier, "the key supplier is null");
        if (Emptys.isEmpty(algorithm)) {
            algorithm = Ciphers.extractAlgorithm(algorithmTransformation);
        }
        CipherAlgorithmSuite suite = (CipherAlgorithmSuite)ALGORITHM_SUITE_REGISTRY.get(algorithm);
        if (Emptys.isEmpty(algorithmTransformation)) {
            if (suite != null) {
                algorithmTransformation = suite.getTransformation();
            }
            if (Emptys.isEmpty(algorithmTransformation)) {
                algorithmTransformation = Ciphers.createAlgorithmTransformation(algorithm, "ECB", "PKCS5Padding");
            }
        }
        Object key = keySupplier.get(keyBytes, algorithm, provider);
        AlgorithmParameterSpec parameterSpec = null;
        AlgorithmParameters parameters = null;
        Object parameter = null;
        if (parameterSupplier == null && suite != null && (parameterSupplier = suite.getParameterSupplier()) == null && Strings.equalsIgnoreCase("SM4", algorithm)) {
            Loggers.getLogger(Ciphers.class).warn("check whether the langx-java-security-gm-jca-bouncycastle.jar (version >= 4.2.7) in the classpath or not");
        }
        if (parameterSupplier == null && provider != null) {
            parameterSupplier = DefaultAlgorithmParameterSupplier.getInstance();
        }
        if (parameterSupplier != null && (parameter = parameterSupplier.get((Key)key, algorithm, algorithmTransformation, provider, secureRandom)) != null) {
            if (parameter instanceof AlgorithmParameterSpec) {
                parameterSpec = (AlgorithmParameterSpec)parameter;
            } else if (parameter instanceof AlgorithmParameters) {
                parameters = (AlgorithmParameters)parameter;
            } else if (parameter instanceof AlgorithmParameterGenerator) {
                AlgorithmParameterGenerator parameterGenerator = (AlgorithmParameterGenerator)parameter;
                parameters = parameterGenerator.generateParameters();
            }
        }
        try {
            Cipher cipher = null;
            cipher = parameters != null ? Ciphers.createCipher(algorithmTransformation, provider, encrypt ? 1 : 2, key, parameters, secureRandom) : Ciphers.createCipher(algorithmTransformation, provider, encrypt ? 1 : 2, key, parameterSpec, secureRandom);
            if (encrypt) {
                return Ciphers.encrypt(cipher, bytes);
            }
            return Ciphers.decrypt(cipher, bytes);
        }
        catch (Throwable ex) {
            throw new CryptoException(ex.getMessage(), ex);
        }
    }

    public static String createAlgorithmTransformation(String transformation) {
        Preconditions.checkNotEmpty(transformation, "the cipher algorithm transformation is null or empty");
        String[] components = Strings.split(transformation, "/");
        if (components.length == 0) {
            throw new IllegalParameterException(StringTemplates.formatWithPlaceholder("the cipher algorithm transformation is illegal: {}", transformation));
        }
        if (components.length < 3) {
            return components[0];
        }
        return Ciphers.createAlgorithmTransformation(components[0], components[1], components[2]);
    }

    public static String createAlgorithmTransformation(@NotEmpty String algorithm, @NotEmpty String mode, @NotEmpty String padding) {
        Preconditions.checkNotEmpty(algorithm, "the algorithm is null or empty");
        Preconditions.checkNotEmpty(mode, "the mode is null or empty");
        Preconditions.checkNotEmpty(padding, "the padding is null or empty");
        return StringTemplates.formatWithPlaceholder("{}/{}/{}", algorithm, mode, padding);
    }

    public static String extractAlgorithm(String transformation) {
        Preconditions.checkNotEmpty(transformation, "the cipher algorithm transformation is null or empty");
        String[] segments = Strings.split(transformation, "/");
        Preconditions.checkNotEmpty(segments, "invalid transformation: {}", transformation);
        return segments[0];
    }

    public static Symmetrics.MODE extractSymmetricMode(String algorithmTransformation) {
        String[] segments = Strings.split(algorithmTransformation, "/");
        Preconditions.checkArgument(segments.length == 1 || segments.length == 3, "illegal algorithm transformation: {}", algorithmTransformation);
        if (segments.length == 1) {
            return Ciphers.extractSymmetricMode(Ciphers.getDefaultTransformation(segments[0].toUpperCase()));
        }
        if (segments.length == 3) {
            return Enums.ofName(Symmetrics.MODE.class, segments[1].toUpperCase());
        }
        return null;
    }

    public static String extractCipherAlgorithm(String algorithm) {
        int indexOfWith;
        Preconditions.checkNotNull(algorithm, "algorithm must be not null !");
        if ((algorithm.contains("SM2") || algorithm.contains("EC")) && (indexOfWith = Strings.lastIndexOfIgnoreCase(algorithm, "with")) > 0) {
            algorithm = Strings.substring(algorithm, indexOfWith + "with".length());
        }
        if (Strings.contains(algorithm, "with", true)) {
            indexOfWith = Strings.lastIndexOfIgnoreCase(algorithm, "with");
            algorithm = Strings.substring(algorithm, indexOfWith + "with".length());
        } else if ("ECDSA".equalsIgnoreCase(algorithm)) {
            algorithm = "EC";
        }
        if (Strings.startsWith(algorithm, "EC", true)) {
            algorithm = "EC";
        }
        return algorithm;
    }

    public static CipherAlgorithmSuiteRegistry getAlgorithmSuiteRegistry() {
        return ALGORITHM_SUITE_REGISTRY;
    }

    static {
        ALGORITHM_SUITE_REGISTRY.init();
    }
}

