/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.crypto.key.spi;

import com.jn.langx.security.crypto.key.SecureRandoms;
import com.jn.langx.security.crypto.key.spi.CipherKeyGeneratorEngine;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class BaseKeyGeneratorSpi
extends KeyGeneratorSpi {
    protected String algorithm;
    protected int keySize;
    protected int defaultKeySize;
    protected CipherKeyGeneratorEngine engine;
    protected boolean initialed = false;

    public BaseKeyGeneratorSpi(String algorithm, int defaultKeySize) {
        this(algorithm, defaultKeySize, new CipherKeyGeneratorEngine());
    }

    public BaseKeyGeneratorSpi(String algorithm, int defaultKeySize, CipherKeyGeneratorEngine engine) {
        this.algorithm = algorithm;
        this.keySize = this.defaultKeySize = defaultKeySize;
        this.engine = engine;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("Not Implemented");
    }

    @Override
    protected void engineInit(SecureRandom random) {
        this.engineInit(this.defaultKeySize, random);
    }

    @Override
    protected void engineInit(int keySize, SecureRandom random) {
        try {
            if (random == null) {
                random = SecureRandoms.getDefault();
            }
            this.engine.init(keySize, random);
            this.initialed = true;
        }
        catch (IllegalArgumentException e) {
            throw new InvalidParameterException(e.getMessage());
        }
    }

    @Override
    protected SecretKey engineGenerateKey() {
        if (!this.initialed) {
            this.engineInit(this.defaultKeySize, SecureRandoms.getDefault());
        }
        return new SecretKeySpec(this.engine.generateKey(), this.algorithm);
    }
}

