/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.grok;

import com.jn.langx.Converter;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.text.grok.Converters;
import com.jn.langx.text.grok.Grok;
import com.jn.langx.text.grok.GrokException;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.regexp.RegexpMatcher;
import com.jn.langx.util.regexp.Regexps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class Match {
    public static final Match EMPTY = new Match("", null, null, 0, 0);
    private final CharSequence subject;
    private final Grok grok;
    private final RegexpMatcher match;
    private final int start;
    private final int end;
    private boolean keepEmptyCaptures = true;
    private Map<String, Object> capture = Collections.emptyMap();

    public Match(CharSequence subject, Grok grok, RegexpMatcher match, int start, int end) {
        this.subject = subject;
        this.grok = grok;
        this.match = match;
        this.start = start;
        this.end = end;
    }

    public RegexpMatcher getMatch() {
        return this.match;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public boolean isKeepEmptyCaptures() {
        return this.keepEmptyCaptures;
    }

    public void setKeepEmptyCaptures(boolean ignore) {
        if (this.capture.size() > 0) {
            this.capture = new HashMap<String, Object>();
        }
        this.keepEmptyCaptures = ignore;
    }

    public CharSequence getSubject() {
        return this.subject;
    }

    public Map<String, Object> capture() {
        return this.capture(false);
    }

    public Map<String, Object> captureFlattened() throws GrokException {
        return this.capture(true);
    }

    private Map<String, Object> capture(final boolean flattened) throws GrokException {
        if (this.match == null) {
            return Collections.emptyMap();
        }
        if (!this.capture.isEmpty()) {
            return this.capture;
        }
        this.capture = new HashMap<String, Object>();
        Map<String, String> mappedw = Regexps.namedGroups(this.match, this.grok.namedGroups);
        Collects.forEach(mappedw, new Consumer2<String, String>(){

            @Override
            public void accept(String key, String valueString) {
                String id = Match.this.grok.getNamedRegexCollectionById(key);
                if (id != null && !id.isEmpty()) {
                    key = id;
                }
                if ("UNWANTED".equals(key)) {
                    return;
                }
                String value = valueString;
                if (valueString != null) {
                    Converter converter = ((Match)Match.this).grok.converters.get(key);
                    if (converter != null) {
                        key = Converters.extractKey(key);
                        try {
                            value = converter.apply(valueString);
                        }
                        catch (Exception e) {
                            Match.this.capture.put(key + "_grokfailure", e.toString());
                        }
                        if (value instanceof String) {
                            value = Match.this.cleanString(value);
                        }
                    } else {
                        value = Match.this.cleanString(valueString);
                    }
                } else if (!Match.this.isKeepEmptyCaptures()) {
                    return;
                }
                if (Match.this.capture.containsKey(key)) {
                    Object currentValue = Match.this.capture.get(key);
                    if (flattened) {
                        if (currentValue == null && value != null) {
                            Match.this.capture.put(key, value);
                        }
                        if (currentValue != null && value != null) {
                            throw new GrokException(StringTemplates.formatWithCStyle("key '%s' has multiple non-null values, this is not allowed in flattened mode, values:'%s', '%s'", key, currentValue, value));
                        }
                    } else if (currentValue instanceof List) {
                        List cvl = (List)currentValue;
                        cvl.add(value);
                    } else {
                        ArrayList<Object> list = new ArrayList<Object>();
                        list.add(currentValue);
                        list.add(value);
                        Match.this.capture.put(key, list);
                    }
                } else {
                    Match.this.capture.put(key, value);
                }
            }
        });
        this.capture = Collections.unmodifiableMap(this.capture);
        return this.capture;
    }

    private String cleanString(String value) {
        char lastChar;
        if (value == null || value.isEmpty()) {
            return value;
        }
        char firstChar = value.charAt(0);
        if (firstChar == (lastChar = value.charAt(value.length() - 1)) && (firstChar == '\"' || firstChar == '\'')) {
            if (value.length() <= 2) {
                return "";
            }
            int found = 0;
            for (int i = 1; i < value.length() - 1; ++i) {
                if (value.charAt(i) != firstChar) continue;
                ++found;
            }
            if (found == 0) {
                return value.substring(1, value.length() - 1);
            }
        }
        return value;
    }

    public Boolean isNull() {
        return this.match == null;
    }
}

