/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.xml;

import com.jn.langx.text.xml.Namespace;
import com.jn.langx.text.xml.Namespaces;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.iter.Iterables;
import com.jn.langx.util.function.Function;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class NodeNamespaceContext
implements NamespaceContext {
    private String defaultPrefix;
    private Map<String, Namespace> prefixToNamespaceMap;
    private Map<String, List<Namespace>> uriToNamespacesMap;

    public NodeNamespaceContext(Document document, String defaultPrefix) {
        this(document.getDocumentElement());
        this.setDefaultPrefix(defaultPrefix);
    }

    public NodeNamespaceContext(Document document) {
        this(document.getDocumentElement());
    }

    public NodeNamespaceContext(Node node, String defaultPrefix) {
        this(node);
        this.setDefaultPrefix(defaultPrefix);
    }

    public NodeNamespaceContext(Node node) {
        this.prefixToNamespaceMap = Namespaces.findNamespaces(node);
        this.reGroup();
    }

    public void setDefaultPrefix(String defaultPrefix) {
        this.defaultPrefix = defaultPrefix;
        this.reGroup();
    }

    private void reGroup() {
        if (this.prefixToNamespaceMap != null) {
            if (Strings.isNotBlank(this.defaultPrefix) && !this.defaultPrefix.equals("xmlns") && this.prefixToNamespaceMap.get("xmlns") != null) {
                this.prefixToNamespaceMap.put(this.defaultPrefix, this.prefixToNamespaceMap.get("xmlns"));
            }
            this.uriToNamespacesMap = Collects.groupBy(this.prefixToNamespaceMap.values(), new Function<Namespace, String>(){

                @Override
                public String apply(Namespace namespace) {
                    return namespace.getUri();
                }
            });
        }
    }

    @Override
    public String getNamespaceURI(String prefix) {
        Namespace namespace = this.prefixToNamespaceMap.get(prefix);
        if (namespace != null) {
            return namespace.getUri();
        }
        return "";
    }

    @Override
    public String getPrefix(String namespaceURI) {
        List<Namespace> namespaces = this.uriToNamespacesMap.get(namespaceURI);
        if (!Objs.isEmpty(namespaces)) {
            return namespaces.get(0).getPrefix();
        }
        return "";
    }

    public Iterator getPrefixes(String namespaceURI) {
        List<Namespace> namespaces = this.uriToNamespacesMap.get(namespaceURI);
        return Iterables.getIterator(namespaces);
    }
}

