/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.classpath.classloader.ClassLoaderAccessor;
import com.jn.langx.classpath.classloader.ExceptionIgnoringAccessor;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.NonAbsentHashMap;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Supplier;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.reflect.Reflects;
import com.jn.langx.util.reflect.type.Primitives;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.jar.JarFile;
import org.slf4j.Logger;

public class ClassLoaders {
    public static final ClassLoaderAccessor THREAD_CL_ACCESSOR = new ExceptionIgnoringAccessor(){

        @Override
        protected ClassLoader doGetClassLoader() throws Throwable {
            return Thread.currentThread().getContextClassLoader();
        }
    };
    public static final ClassLoaderAccessor CLASS_CL_ACCESSOR = new ExceptionIgnoringAccessor(){

        @Override
        protected ClassLoader doGetClassLoader() throws Throwable {
            return ClassLoaders.class.getClassLoader();
        }
    };
    public static final ClassLoaderAccessor SYSTEM_CL_ACCESSOR = new ExceptionIgnoringAccessor(){

        @Override
        protected ClassLoader doGetClassLoader() throws Throwable {
            return ClassLoader.getSystemClassLoader();
        }
    };
    private static final Map<Class<?>, Method> addURLMethodMap = new NonAbsentHashMap(new Supplier<Class<?>, Method>(){

        @Override
        public Method get(Class<?> urlClassLoaderClass) {
            if (!Reflects.isSubClassOrEquals(URLClassLoader.class, urlClassLoaderClass)) {
                return null;
            }
            Method addURLMethod = Reflects.getAnyMethod(urlClassLoaderClass, "addURL", URL.class);
            if (addURLMethod != null) {
                addURLMethod.setAccessible(true);
            }
            return addURLMethod;
        }
    });

    private ClassLoaders() {
    }

    public static ClassLoader getClassLoader(final Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz.getClassLoader();
            }
        });
    }

    public static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    public static ClassLoader getExtClassLoader() {
        return ClassLoaders.getSystemClassLoader().getParent();
    }

    public static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }

    public static Class loadClass(@NonNull String className) throws ClassNotFoundException {
        return ClassLoaders.loadClass(className, (ClassLoader)null);
    }

    public static Class loadClass(@NonNull String className, @Nullable Class basedClass) throws ClassNotFoundException {
        return ClassLoaders.loadClass(className, basedClass.getClassLoader());
    }

    public static Class loadClass(@NonNull String className, @Nullable ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        if (clazz == null && currentThreadClassLoader != null) {
            clazz = Class.forName(className, true, currentThreadClassLoader);
        }
        if (clazz == null) {
            throw new ClassNotFoundException("Failed to load class" + className);
        }
        return clazz;
    }

    public static Class loadImplClass(@NonNull String className, @Nullable ClassLoader classLoader, Class superClass) throws ClassNotFoundException {
        Class clazz = ClassLoaders.loadClass(className, classLoader);
        if (!Reflects.isSubClass(superClass, clazz)) {
            String error = "Class " + Reflects.getFQNClassName(clazz) + " is not cast to " + Reflects.getFQNClassName(superClass);
            throw new ClassCastException(error);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <I, O> O doAction(@NonNull ClassLoader threadContextClassLoader, @NonNull Function<I, O> action, @Nullable I input) {
        Preconditions.checkNotNull(threadContextClassLoader);
        Preconditions.checkNotNull(action);
        ClassLoader originalThreadCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(threadContextClassLoader);
        try {
            O o = action.apply(input);
            return o;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalThreadCL);
        }
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = ClassLoaders.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    public static boolean hasClass(@NonNull String classFQN, @Nullable ClassLoader classLoader) {
        Preconditions.checkNotNull(classFQN, "the calss name is null or empty");
        while (classFQN.endsWith(".class")) {
            classFQN = classFQN.substring(0, classFQN.length() - ".class".length());
        }
        Class c = null;
        try {
            c = ClassLoaders.loadClass(classFQN, classLoader);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return c != null;
    }

    public static Class<?> forName(String fqcn) throws ClassNotFoundException {
        Class clazz = THREAD_CL_ACCESSOR.loadClass(fqcn);
        Logger logger = Loggers.getLogger(ClassLoaders.class);
        if (clazz == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("Unable to load class named [{}] from the thread context ClassLoader. Trying the current ClassLoader...", (Object)fqcn);
            }
            clazz = CLASS_CL_ACCESSOR.loadClass(fqcn);
        }
        if (clazz == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("Unable to load class named [{}] from the current ClassLoader. Trying the system/application ClassLoader...", (Object)fqcn);
            }
            clazz = SYSTEM_CL_ACCESSOR.loadClass(fqcn);
        }
        if (clazz == null) {
            clazz = Primitives.get(fqcn);
        }
        if (clazz == null) {
            String msg = StringTemplates.formatWithPlaceholder("Unable to load class named [{}] from the thread context, current, or system/application ClassLoaders.  All heuristics have been exhausted.  Class could not be found.", fqcn);
            throw new ClassNotFoundException(msg);
        }
        return clazz;
    }

    public static boolean isAvailable(String fullyQualifiedClassName) {
        try {
            ClassLoaders.forName(fullyQualifiedClassName);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static InputStream getResourceAsStream(String name) {
        InputStream is = THREAD_CL_ACCESSOR.getResourceStream(name);
        Logger logger = Loggers.getLogger(ClassLoaders.class);
        if (is == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Resource [{}] was not found via the thread context ClassLoader.  Trying the current ClassLoader...", (Object)name);
            }
            is = CLASS_CL_ACCESSOR.getResourceStream(name);
        }
        if (is == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Resource [{}] was not found via the current class loader.  Trying the system/application ClassLoader...", (Object)name);
            }
            is = SYSTEM_CL_ACCESSOR.getResourceStream(name);
        }
        if (is == null && logger.isDebugEnabled()) {
            logger.debug("Resource [{}] was not found via the thread context, current, or system/application ClassLoaders.  All heuristics have been exhausted.  Returning null.", (Object)name);
        }
        return is;
    }

    public static boolean addUrl(URLClassLoader urlClassLoader, URL jarUrl) {
        return ClassLoaders.addUrl(urlClassLoader, jarUrl, false);
    }

    public static boolean addUrl(URLClassLoader urlClassLoader, URL jarUrl, boolean force) {
        if (urlClassLoader == null || jarUrl == null) {
            return false;
        }
        if (ClassLoaders.getExtClassLoader() == urlClassLoader && !force) {
            return false;
        }
        Method addURLMethod = addURLMethodMap.get(urlClassLoader.getClass());
        if (addURLMethod != null) {
            try {
                Reflects.invoke(addURLMethod, urlClassLoader, new Object[]{jarUrl}, true, true);
            }
            catch (Throwable ex) {
                return false;
            }
        }
        return true;
    }

    public static URL getJarUrl(Class<?> klass) {
        URL location = Reflects.getCodeLocation(klass);
        return location;
    }

    public static JarFile getJarFile(Class<?> klass) {
        URL location = Reflects.getCodeLocation(klass);
        if (location != null) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(new File(location.toURI()));
                return jarFile;
            }
            catch (Throwable ex) {
                Logger logger = Loggers.getLogger(ClassLoaders.class);
                logger.warn("Can't find the jar for class: {}", (Object)Reflects.getFQNClassName(klass));
                IOs.close(jarFile);
            }
        }
        return null;
    }
}

