/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.util.BasedStringAccessor;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Arrs;
import java.lang.reflect.Array;

public class ArrayAccessor<E>
extends BasedStringAccessor<Integer, E> {
    public ArrayAccessor() {
    }

    public ArrayAccessor(E target) {
        this.setTarget(target);
    }

    @Override
    public void setTarget(@NonNull E target) {
        Preconditions.checkNotNull(target);
        Preconditions.checkTrue(Arrs.isArray(target));
        super.setTarget(target);
    }

    @Override
    public boolean has(Integer index) {
        int length = Array.getLength(this.getTarget());
        return index >= 0 && index < length;
    }

    @Override
    public Object get(Integer index) {
        return Array.get(this.getTarget(), index);
    }

    @Override
    public String getString(Integer index, String defaultValue) {
        Object o = this.get(index);
        return o == null ? defaultValue : o.toString();
    }

    @Override
    public void set(Integer index, Object value) {
        Array.set(this.getTarget(), index, value);
    }

    @Override
    public void remove(Integer index) {
        this.set(index, (Object)null);
    }
}

