/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;

public class LinkedCaseInsensitiveSet
extends LinkedHashSet<String> {
    private static final long serialVersionUID = 1L;
    private final Locale locale;
    private Map<String, String> cache = new HashMap<String, String>();

    public LinkedCaseInsensitiveSet() {
        this.locale = Locale.getDefault();
    }

    public LinkedCaseInsensitiveSet(Locale locale) {
        this.locale = locale != null ? locale : Locale.getDefault();
    }

    public LinkedCaseInsensitiveSet(Locale locale, Collection<? extends String> source) {
        this(locale);
        this.addAll(source);
    }

    @Override
    public boolean add(String element) {
        String lowercase = element.toLowerCase(this.locale);
        if (!this.cache.containsKey(lowercase)) {
            super.add(element);
            this.cache.put(lowercase, element);
            return true;
        }
        return false;
    }

    public boolean contains(String element) {
        String lowercase = element.toLowerCase(this.locale);
        return this.cache.containsKey(lowercase);
    }

    @Override
    public boolean contains(Object o) {
        return this.contains(o.toString());
    }

    @Override
    public boolean remove(Object o) {
        String lowercase = o.toString().toLowerCase(this.locale);
        String value = this.cache.remove(lowercase);
        if (value != null) {
            return super.remove(value);
        }
        return false;
    }

    @Override
    public void clear() {
        super.clear();
        this.cache.clear();
    }
}

