/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.Maths;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.concurrent.threadlocal.GlobalThreadLocalMap;
import com.jn.langx.util.function.Collector;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Function2;
import com.jn.langx.util.function.Functions;
import com.jn.langx.util.function.Operator2;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.function.Predicate2;
import com.jn.langx.util.function.Supplier0;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class Pipeline<E> {
    private Collection<E> collection;

    public <C extends Collection<E>> Pipeline(C collection) {
        Preconditions.checkNotNull(collection);
        this.collection = collection;
    }

    public <O> Pipeline<O> map(Function<E, O> mapper) {
        return new Pipeline<E>(Collects.map(this.collection, mapper));
    }

    public <O> Pipeline<O> flat() {
        return this.flatMap(Functions.noopFunction());
    }

    public <I, O> Pipeline<O> flatMap(Function<I, O> mapper) {
        Collection<E> c = this.collection;
        Collection<O> list = Collects.flatMap(c, mapper);
        return new Pipeline<E>(list);
    }

    public <O> O firstMap(@NonNull Function2<Integer, E, O> mapper) {
        return Collects.firstMap(this.collection, mapper);
    }

    public <O> O firstMap(@NonNull Function2<Integer, E, O> mapper, Predicate<O> breakPredicate) {
        return Collects.firstMap(this.collection, mapper, breakPredicate);
    }

    public <O> O firstMap(@NonNull Function2<Integer, E, O> mapper, Predicate2<E, O> breakPredicate) {
        return Collects.firstMap(this.collection, mapper, breakPredicate);
    }

    public Pipeline<E> filter(Predicate<E> predicate) {
        return this.filter(predicate, null);
    }

    public Pipeline<E> filter(Predicate<E> predicate, @Nullable Predicate<E> breakPredicate) {
        return new Pipeline<E>(Collects.filter(this.collection, predicate, breakPredicate));
    }

    public Pipeline<E> filter(Predicate2<Integer, E> predicate) {
        return this.filter(predicate, null);
    }

    public Pipeline<E> filter(Predicate2<Integer, E> predicate, @Nullable Predicate2<Integer, E> breakPredicate) {
        return new Pipeline<E>(Collects.filter(this.collection, predicate, breakPredicate));
    }

    public Pipeline<E> limit(int maxSize) {
        maxSize = Maths.max(0, maxSize);
        List list = Collects.limit(this.collection, maxSize);
        return new Pipeline<E>(list);
    }

    public Pipeline<E> skip(int n) {
        n = Maths.max(0, n);
        List list = Collects.skip(this.collection, n);
        return new Pipeline<E>(list);
    }

    public <K> Pipeline<List<E>> partitionBy(Function<E, K> classifier) {
        return new Pipeline<List<E>>(Collects.partitionBy(this.collection, classifier));
    }

    public <K> Pipeline<List<E>> partitionBy(Function2<Integer, E, K> classifier) {
        return new Pipeline<List<E>>(Collects.partitionBy(this.collection, classifier));
    }

    public Pipeline<E> sorted(@NonNull Comparator<E> comparator) {
        return new Pipeline<E>(Collects.sort(this.collection, comparator));
    }

    public Pipeline<E> sort(@NonNull Comparator<E> comparator) {
        return new Pipeline<E>(Collects.sort(this.collection, comparator));
    }

    public Pipeline<E> distinct() {
        return new Pipeline<E>(Collects.distinct(this.collection));
    }

    public void forEach(@NonNull Consumer<E> consumer) {
        this.forEach(null, consumer, null);
    }

    public void forEach(@Nullable Predicate<E> consumePredicate, Consumer<E> consumer) {
        this.forEach(consumePredicate, consumer, null);
    }

    public void forEach(@NonNull Consumer<E> consumer, @Nullable Predicate<E> breakPredicate) {
        this.forEach(null, consumer, breakPredicate);
    }

    public void forEach(@Nullable Predicate<E> consumePredicate, @NonNull Consumer<E> consumer, @Nullable Predicate<E> breakPredicate) {
        Collects.forEach(this.collection, consumePredicate, consumer, breakPredicate);
    }

    public void forEach(@NonNull Consumer2<Integer, E> consumer) {
        this.forEach(consumer, null);
    }

    public void forEach(@NonNull Consumer2<Integer, E> consumer, @Nullable Predicate2<Integer, E> breakPredicate) {
        this.forEach(null, consumer, breakPredicate);
    }

    public void forEach(@Nullable Predicate2<Integer, E> consumePredicate, @NonNull Consumer2<Integer, E> consumer) {
        this.forEach(consumePredicate, consumer, null);
    }

    public void forEach(@Nullable Predicate2<Integer, E> consumePredicate, @NonNull Consumer2<Integer, E> consumer, @Nullable Predicate2<Integer, E> breakPredicate) {
        Collects.forEach(this.collection, consumePredicate, consumer, breakPredicate);
    }

    public boolean anyMatch(@NonNull Predicate<E> predicate) {
        return Collects.anyMatch(this.collection, predicate);
    }

    public boolean allMatch(@NonNull Predicate<E> predicate) {
        return Collects.allMatch(this.collection, predicate);
    }

    public boolean noneMatch(@NonNull Predicate<E> predicate) {
        return Collects.noneMatch(this.collection, predicate);
    }

    public E findFirst() {
        return Collects.findFirst(this.collection, null);
    }

    public E findFirst(@NonNull Predicate<E> predicate) {
        Preconditions.checkNotNull(predicate);
        return Collects.findFirst(this.collection, predicate);
    }

    public Pipeline<E> findN(int n) {
        return Pipeline.of(Collects.findN(this.collection, null, n));
    }

    public Pipeline<E> findN(@NonNull Predicate<E> predicate, int n) {
        Preconditions.checkNotNull(predicate);
        return Pipeline.of(Collects.findN(this.collection, predicate, n));
    }

    public Pipeline<E> clearNulls() {
        return new Pipeline<E>(Collects.clearNulls(this.collection));
    }

    public int count() {
        return this.collection.size();
    }

    public Object[] toArray() {
        return Collects.toArray(this.collection);
    }

    public E[] toArray(Class<E[]> clazz) {
        return Collects.toArray(this.collection, clazz);
    }

    public Iterator<E> iterator() {
        return this.collection.iterator();
    }

    public Collection<E> getAll() {
        return this.collection;
    }

    public Double sum() {
        return this.map(new Function<E, Double>(){

            @Override
            public Double apply(E e) {
                if (e instanceof Number) {
                    return ((Number)e).doubleValue();
                }
                return 0.0;
            }
        }).reduce(new Operator2<Double>(){

            @Override
            public Double apply(Double input1, Double input2) {
                return input1 + input2;
            }
        });
    }

    public Double average() {
        if (this.count() > 0) {
            return this.sum() / (double)this.count();
        }
        return 0.0;
    }

    public E max(Comparator<E> comparator) {
        return Collects.max(this.collection, comparator);
    }

    public E min(Comparator<E> comparator) {
        return Collects.min(this.collection, comparator);
    }

    public E reduce(Operator2<E> operator) {
        return Collects.reduce(this.collection, operator);
    }

    public <K> Map<K, List<E>> groupBy(Function<E, K> classifier) {
        return Collects.groupBy(this.collection, classifier, null);
    }

    public <K> Map<K, List<E>> groupBy(Function<E, K> classifier, Supplier0<Map<K, List<E>>> mapFactory) {
        return Collects.groupBy(this.collection, classifier, mapFactory);
    }

    public <R> R collect(Collector<E, R> collector) {
        return Collects.collect(this.collection, collector);
    }

    public Pipeline<E> concat(Pipeline<E> another) {
        return this.concat(another.collection);
    }

    public <C extends Collection<E>> Pipeline<E> concat(C another) {
        if (another != null) {
            return new Pipeline<E>(Collects.concat(this.collection, another));
        }
        return this;
    }

    public boolean contains(E e) {
        return Collects.contains(this.collection, e);
    }

    public Pipeline<E> subPipeline(int offset, int limit) {
        return new Pipeline<E>(Collects.skip(Collects.limit(this.collection, limit), offset));
    }

    public Pipeline<E> listized() {
        return new Pipeline<E>((Collection)this.collect(Collects.toList()));
    }

    public <C extends Collection<E>> void addTo(final @NonNull C collection) {
        Preconditions.checkNotNull(collection);
        this.forEach(new Consumer<E>(){

            @Override
            public void accept(E e) {
                collection.add(e);
            }
        });
    }

    public Pipeline<E> add(E e) {
        if (e != null) {
            this.collection.add(e);
        }
        return this;
    }

    public <C extends Collection<E>> Pipeline<E> addAll(@Nullable C collection) {
        if (collection == null) {
            return this;
        }
        this.collection.addAll(collection);
        return this;
    }

    public Pipeline<E> remove(E e) {
        List<E> list = this.asList();
        list.remove(e);
        return new Pipeline<E>(list);
    }

    public Pipeline<E> removeIf(Predicate<E> predicate) {
        Collects.removeIf(this.collection, predicate);
        return this;
    }

    public Pipeline<E> removeAll(Collection<E> removed) {
        Collects.removeAll(this.collection, removed);
        return this;
    }

    public Pipeline<E> shuffle() {
        return this.shuffle(GlobalThreadLocalMap.getRandom());
    }

    public Pipeline<E> shuffle(Random random) {
        List<E> list = this.asList();
        Collects.shuffle(list, random);
        return new Pipeline<E>(list);
    }

    public Pipeline<E> reverse() {
        return this.reverse(false);
    }

    public Pipeline<E> reverse(boolean newOne) {
        if (this.collection instanceof List) {
            return Pipeline.of(Collects.reverse((List)this.collection, newOne));
        }
        return Pipeline.of(this.asList()).reverse(newOne);
    }

    public Pipeline<E> swap(int i, int j) {
        List<E> list = this.asList();
        Collects.swap(list, i, j);
        return new Pipeline<E>(list);
    }

    public Set<E> asSet(boolean sequential) {
        if (sequential && this.collection instanceof LinkedHashSet) {
            return (LinkedHashSet)this.collection;
        }
        HashSet<E> set = Collects.emptyHashSet(sequential);
        set.addAll(this.getAll());
        return set;
    }

    public List<E> asList() {
        if (this.collection instanceof List) {
            return (List)this.collection;
        }
        return new ArrayList<E>(this.getAll());
    }

    public static <T> Pipeline<T> of(@Nullable Object anyObject) {
        Collection list = Collects.asCollection(Collects.asIterable(anyObject, true));
        return new Pipeline(list);
    }

    public static <T> Pipeline<T> of(@Nullable Iterable<T> iterable) {
        Collection<T> list = Collects.asCollection(iterable);
        return new Pipeline(list);
    }

    public static <T> Pipeline<T> of(T ... array) {
        Collection list = Collects.asCollection(Collects.asIterable(array, true));
        return new Pipeline(list);
    }
}

