/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.datetime.grok;

import com.jn.langx.text.grok.pattern.PatternDefinition;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.datetime.Month;
import com.jn.langx.util.datetime.WeekDay;
import com.jn.langx.util.datetime.grok.DateTimeGrokPatternDefinition;
import com.jn.langx.util.function.Consumer2;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;

class DateTimeGrokPatterns {
    public static final String MONTH_PATTERN;
    public static final PatternDefinition PD_MONTH;
    private static final Map<String, Integer> MONTH_STR_TO_INTEGER;
    public static final String WEEK_PATTERN;
    private static final PatternDefinition PD_WEEK;
    private static final Map<String, Integer> WEEK_STR_TO_INTEGER;
    private static final PatternDefinition PD_YEAR;
    private static final PatternDefinition PD_DAY_OF_MONTH;
    private static final PatternDefinition PD_HOUR;
    private static final PatternDefinition PD_MINUTE;
    private static final PatternDefinition PD_SECOND;
    private static final PatternDefinition PD_MILLS;
    private static final PatternDefinition PD_NANOS;
    private static final PatternDefinition PD_MILLS_OR_NANOS;
    private static final PatternDefinition PD_TIMEZONE;
    private static final PatternDefinition PD_AMPM;
    private static final PatternDefinition PD_TIME;
    private static final PatternDefinition PD_DATE;
    private static final PatternDefinition PD_WEEK_MONTH_DAY;
    private static final DateTimeGrokPatternDefinition PD_DATE_TIME;

    DateTimeGrokPatterns() {
    }

    static {
        MONTH_STR_TO_INTEGER = new LinkedHashMap<String, Integer>();
        final StringBuilder monthRegexpBuilder = new StringBuilder(300);
        monthRegexpBuilder.append("(?:(?:0?\\d)|(?:1[012]))");
        Pipeline.of(EnumSet.allOf(Month.class)).forEach(new Consumer2<Integer, Month>(){

            @Override
            public void accept(Integer key, Month month) {
                MONTH_STR_TO_INTEGER.put("" + month.getCode(), month.getCode());
                MONTH_STR_TO_INTEGER.put(month.getFullCode(), month.getCode());
                MONTH_STR_TO_INTEGER.put(month.name(), month.getCode());
                MONTH_STR_TO_INTEGER.put(month.name().toUpperCase(), month.getCode());
                MONTH_STR_TO_INTEGER.put(Strings.upperCaseFirstLetter(month.name()), month.getCode());
                MONTH_STR_TO_INTEGER.put(month.getFullname(), month.getCode());
                MONTH_STR_TO_INTEGER.put(Strings.upperCaseFirstLetter(month.getFullname()), month.getCode());
                MONTH_STR_TO_INTEGER.put(month.getChinese(), month.getCode());
                monthRegexpBuilder.append("|").append("(?:" + month.name() + "|" + Strings.upperCaseFirstLetter(month.name()) + "|" + month.getFullname() + "|" + Strings.upperCaseFirstLetter(month.getFullname()) + "|" + month.getChinese() + ")");
            }
        });
        MONTH_PATTERN = "(?" + monthRegexpBuilder.toString() + ")";
        PD_MONTH = new PatternDefinition("MONTH", MONTH_PATTERN);
        WEEK_STR_TO_INTEGER = new LinkedHashMap<String, Integer>();
        final StringBuilder weekRegexpBuilder = new StringBuilder(300);
        Pipeline.of(EnumSet.allOf(WeekDay.class)).forEach(new Consumer2<Integer, WeekDay>(){

            @Override
            public void accept(Integer key, WeekDay week) {
                WEEK_STR_TO_INTEGER.put(week.name(), week.getCode());
                WEEK_STR_TO_INTEGER.put(week.name().toUpperCase(), week.getCode());
                WEEK_STR_TO_INTEGER.put(Strings.upperCaseFirstLetter(week.name()), week.getCode());
                WEEK_STR_TO_INTEGER.put(week.getFullname(), week.getCode());
                WEEK_STR_TO_INTEGER.put(Strings.upperCaseFirstLetter(week.getFullname()), week.getCode());
                WEEK_STR_TO_INTEGER.put(week.getChinese(), week.getCode());
                weekRegexpBuilder.append("|").append("(?:" + week.name() + "|" + Strings.upperCaseFirstLetter(week.name()) + "|" + week.getFullname() + "|" + Strings.upperCaseFirstLetter(week.getFullname()) + "|" + week.getChinese() + ")");
            }
        });
        WEEK_PATTERN = "(?:" + weekRegexpBuilder.toString() + ")";
        PD_WEEK = new PatternDefinition("WEEK", WEEK_PATTERN);
        PD_YEAR = new PatternDefinition("YEAR", "(?:(?:\\d{2}{1,2}))");
        PD_DAY_OF_MONTH = new PatternDefinition("DAY_OF_MONTH", "(?:[0-3]?\\d)");
        PD_HOUR = new PatternDefinition("HOUR", "(?:[0-2]?\\d)");
        PD_MINUTE = new PatternDefinition("MINUTE", "(?:[0-5]?\\d)");
        PD_SECOND = new PatternDefinition("SECOND", "(?:[0-5]?\\d)");
        PD_MILLS = new PatternDefinition("MILLS", "\\d{1,3}");
        PD_NANOS = new PatternDefinition("NANOS", "\\d{9}");
        PD_MILLS_OR_NANOS = new PatternDefinition("MILLS_NANOS", "(?:\\d{9}|\\d{1,3})");
        PD_TIMEZONE = new PatternDefinition("TIMEZONE", "(?:[a-zA-Z_-]+(?:(?:/[a-zA-Z_-]+))|(?:[+-]\\d{2}:?\\d{2}))");
        PD_AMPM = new PatternDefinition("AMPM", "(?:(?:[aApP][mM]?)|(?:[\u4e0a\u4e0b]\u5348))");
        PD_TIME = new PatternDefinition("YYYY_MM_DD", "%{YEAR:year}:%{MONTH:month}:%{DAY_OF_MONTH:dayOfMonth}");
        PD_DATE = new PatternDefinition("YYYY_MM_DD2", "%{YEAR:year}/%{MONTH:month}/%{DAY_OF_MONTH:dayOfMonth}");
        PD_WEEK_MONTH_DAY = new PatternDefinition("WEEK_MONTH_DAY", "%{WEEK:week} %{MONTH:month} %{DAY_OF_MONTH:dayOfMonth}");
        PD_DATE_TIME = new DateTimeGrokPatternDefinition("yyy", "");
    }
}

