/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.id;

import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;

public final class Xid
implements Comparable<Xid> {
    private static final int ID_LENGTH = 12;
    private static final int LOW_ORDER_THREE_BYTES = 0xFFFFFF;
    private static final int RANDOM_VALUE1;
    private static final short RANDOM_VALUE2;
    private static final AtomicInteger NEXT_COUNTER;
    private static final char[] BASE32_HEX_CHARS;
    private static final int[] BASE32_LOOKUP_TABLE;
    private final int timestamp;
    private final int counter;
    private final int randomValue1;
    private final short randomValue2;

    public Xid() {
        this(new Date());
    }

    public Xid(Date date) {
        this(Xid.dateToTimestampSeconds(date), NEXT_COUNTER.getAndIncrement() & 0xFFFFFF, false);
    }

    public Xid(Date date, int counter) {
        this(Xid.dateToTimestampSeconds(date), counter, true);
    }

    public Xid(int timestamp, int counter) {
        this(timestamp, counter, true);
    }

    private Xid(int timestamp, int counter, boolean checkCounter) {
        this(timestamp, RANDOM_VALUE1, RANDOM_VALUE2, counter, checkCounter);
    }

    private Xid(int timestamp, int randomValue1, short randomValue2, int counter, boolean checkCounter) {
        if ((randomValue1 & 0xFF000000) != 0) {
            throw new IllegalArgumentException("The machine identifier must be between 0 and 16777215 (it must fit in three bytes).");
        }
        if (checkCounter && (counter & 0xFF000000) != 0) {
            throw new IllegalArgumentException("The counter must be between 0 and 16777215 (it must fit in three bytes).");
        }
        this.timestamp = timestamp;
        this.counter = counter & 0xFFFFFF;
        this.randomValue1 = randomValue1;
        this.randomValue2 = randomValue2;
    }

    public Xid(String hexString) {
        this(Xid.parseHexString(hexString));
    }

    public Xid(byte[] bytes) {
        this(ByteBuffer.wrap(Xid.isTrue("bytes has length of 12", bytes, Xid.paramNotNull("bytes", bytes).length == 12)));
    }

    public Xid(ByteBuffer buffer) {
        Xid.paramNotNull("buffer", buffer);
        Xid.isTrue("buffer.remaining() >=12", buffer.remaining() >= 12);
        this.timestamp = Xid.makeInt(buffer.get(), buffer.get(), buffer.get(), buffer.get());
        this.randomValue1 = Xid.makeInt((byte)0, buffer.get(), buffer.get(), buffer.get());
        this.randomValue2 = Xid.makeShort(buffer.get(), buffer.get());
        this.counter = Xid.makeInt((byte)0, buffer.get(), buffer.get(), buffer.get());
    }

    public static Xid get() {
        return new Xid();
    }

    public static String string() {
        return Xid.get().toHexString();
    }

    public static byte[] bytes() {
        return Xid.get().toByteArray();
    }

    public static Xid getSmallestWithDate(Date date) {
        return new Xid(Xid.dateToTimestampSeconds(date), 0, 0, 0, false);
    }

    public byte[] toByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(12);
        this.putToByteBuffer(buffer);
        return buffer.array();
    }

    public void putToByteBuffer(ByteBuffer buffer) {
        Xid.paramNotNull("buffer", buffer);
        Xid.isTrue("buffer.remaining() >=12", buffer.remaining() >= 12);
        buffer.put(Xid.int3(this.timestamp));
        buffer.put(Xid.int2(this.timestamp));
        buffer.put(Xid.int1(this.timestamp));
        buffer.put(Xid.int0(this.timestamp));
        buffer.put(Xid.int2(this.randomValue1));
        buffer.put(Xid.int1(this.randomValue1));
        buffer.put(Xid.int0(this.randomValue1));
        buffer.put(Xid.short1(this.randomValue2));
        buffer.put(Xid.short0(this.randomValue2));
        buffer.put(Xid.int2(this.counter));
        buffer.put(Xid.int1(this.counter));
        buffer.put(Xid.int0(this.counter));
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public Date getDate() {
        return new Date(((long)this.timestamp & 0xFFFFFFFFL) * 1000L);
    }

    public String toHexString() {
        return Xid.base32Hex(this.toByteArray());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Xid other = (Xid)o;
        if (this.counter != other.counter) {
            return false;
        }
        if (this.timestamp != other.timestamp) {
            return false;
        }
        if (this.randomValue1 != other.randomValue1) {
            return false;
        }
        return this.randomValue2 == other.randomValue2;
    }

    public int hashCode() {
        int result = this.timestamp;
        result = 31 * result + this.counter;
        result = 31 * result + this.randomValue1;
        result = 31 * result + this.randomValue2;
        return result;
    }

    @Override
    public int compareTo(Xid other) {
        if (other == null) {
            throw new NullPointerException();
        }
        byte[] byteArray = this.toByteArray();
        byte[] otherByteArray = other.toByteArray();
        for (int i = 0; i < 12; ++i) {
            if (byteArray[i] == otherByteArray[i]) continue;
            return (byteArray[i] & 0xFF) < (otherByteArray[i] & 0xFF) ? -1 : 1;
        }
        return 0;
    }

    public String toString() {
        return this.toHexString();
    }

    public static boolean isValid(String hexString) {
        if (hexString == null) {
            throw new IllegalArgumentException();
        }
        int len = hexString.length();
        if (len != 20) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char c = hexString.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'v') continue;
            return false;
        }
        return true;
    }

    private static byte[] parseHexString(String id) {
        if (!Xid.isValid(id)) {
            throw new IllegalArgumentException("invalid hexadecimal representation of an Xid: [" + id + "]");
        }
        return Xid.base32Hex(id);
    }

    private static String base32Hex(byte[] bytes) {
        int i = 0;
        int index = 0;
        int digit = 0;
        StringBuilder base32 = new StringBuilder((bytes.length + 7) * 8 / 5);
        while (i < bytes.length) {
            int currByte;
            int n = currByte = bytes[i] >= 0 ? bytes[i] : bytes[i] + 256;
            if (index > 3) {
                int nextByte = i + 1 < bytes.length ? (bytes[i + 1] >= 0 ? bytes[i + 1] : bytes[i + 1] + 256) : 0;
                digit = currByte & 255 >> index;
                index = (index + 5) % 8;
                digit <<= index;
                digit |= nextByte >> 8 - index;
                ++i;
            } else {
                digit = currByte >> 8 - (index + 5) & 0x1F;
                if ((index = (index + 5) % 8) == 0) {
                    ++i;
                }
            }
            base32.append(BASE32_HEX_CHARS[digit]);
        }
        return base32.toString();
    }

    private static byte[] base32Hex(String base32) {
        byte[] bytes = new byte[base32.length() * 5 / 8];
        int index = 0;
        int offset = 0;
        for (int i = 0; i < base32.length(); ++i) {
            int digit;
            int lookup = base32.charAt(i) - 48;
            if (lookup < 0 || lookup >= BASE32_LOOKUP_TABLE.length || (digit = BASE32_LOOKUP_TABLE[lookup]) == 255) continue;
            if (index <= 3) {
                if ((index = (index + 5) % 8) == 0) {
                    int n = offset++;
                    bytes[n] = (byte)(bytes[n] | digit);
                    if (offset < bytes.length) continue;
                    break;
                }
                int n = offset;
                bytes[n] = (byte)(bytes[n] | digit << 8 - index);
                continue;
            }
            index = (index + 5) % 8;
            int n = offset++;
            bytes[n] = (byte)(bytes[n] | digit >>> index);
            if (offset >= bytes.length) break;
            int n2 = offset;
            bytes[n2] = (byte)(bytes[n2] | digit << 8 - index);
        }
        return bytes;
    }

    private static int dateToTimestampSeconds(Date time) {
        return (int)(time.getTime() / 1000L);
    }

    private static int makeInt(byte b3, byte b2, byte b1, byte b0) {
        return b3 << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | b0 & 0xFF;
    }

    private static short makeShort(byte b1, byte b0) {
        return (short)((b1 & 0xFF) << 8 | b0 & 0xFF);
    }

    private static byte int3(int x) {
        return (byte)(x >> 24);
    }

    private static byte int2(int x) {
        return (byte)(x >> 16);
    }

    private static byte int1(int x) {
        return (byte)(x >> 8);
    }

    private static byte int0(int x) {
        return (byte)x;
    }

    private static byte short1(short x) {
        return (byte)(x >> 8);
    }

    private static byte short0(short x) {
        return (byte)x;
    }

    public static void isTrue(String name, boolean condition) {
        if (!condition) {
            throw new IllegalStateException("state should be: " + name);
        }
    }

    static <T> T isTrue(String name, T value, boolean condition) {
        if (!condition) {
            throw new IllegalArgumentException("state should be: " + name);
        }
        return value;
    }

    static <T> T paramNotNull(String name, T value) {
        if (value == null) {
            throw new IllegalArgumentException(name + " can not be null");
        }
        return value;
    }

    static {
        NEXT_COUNTER = new AtomicInteger(new SecureRandom().nextInt());
        BASE32_HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v'};
        BASE32_LOOKUP_TABLE = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 255, 255, 255, 255, 255, 255, 255, 255, 255};
        try {
            SecureRandom secureRandom = new SecureRandom();
            RANDOM_VALUE1 = secureRandom.nextInt(0x1000000);
            RANDOM_VALUE2 = (short)secureRandom.nextInt(32768);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

