/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.io.unicode;

import com.jn.langx.Transformer;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.text.placeholder.PlaceholderParser;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.io.Charsets;
import com.jn.langx.util.regexp.Regexp;
import com.jn.langx.util.regexp.Regexps;

public class Utf8s {
    public static final Regexp ESCAPED_CHAR_REGEXP = Regexps.createRegexp("(?:(?:\\\\0)[0-3][0-7]{2})|(?:(?:\\\\0)[0-7]{1,2})|(?:(?:\\\\x)[0-9a-fA-F]{2})|(?:(?:\\\\u)[0-9a-fA-F]{4})");
    public static final Regexp X16_CHAR_REGEXP = Regexps.createRegexp("(?:(?:\\\\x)[0-9a-fA-F]{2})");

    public static boolean isValidUTF8(@NonNull byte[] b) {
        int i = 0;
        while (i < b.length) {
            byte currentByte;
            if (((currentByte = b[i++]) & 0x80) == 0) continue;
            if ((currentByte & 0xE0) == 192) {
                if (!Utf8s.hasExpectedSubsequentUTF8Bytes(b, i, 1)) {
                    return false;
                }
                ++i;
                continue;
            }
            if ((currentByte & 0xF0) == 224) {
                if (!Utf8s.hasExpectedSubsequentUTF8Bytes(b, i, 2)) {
                    return false;
                }
                i += 2;
                continue;
            }
            if ((currentByte & 0xF8) == 240) {
                if (!Utf8s.hasExpectedSubsequentUTF8Bytes(b, i, 3)) {
                    return false;
                }
                i += 3;
                continue;
            }
            if ((currentByte & 0xFC) == 248) {
                if (!Utf8s.hasExpectedSubsequentUTF8Bytes(b, i, 4)) {
                    return false;
                }
                i += 4;
                continue;
            }
            if ((currentByte & 0xFE) == 252) {
                if (!Utf8s.hasExpectedSubsequentUTF8Bytes(b, i, 5)) {
                    return false;
                }
                i += 5;
                continue;
            }
            return false;
        }
        return true;
    }

    private static boolean hasExpectedSubsequentUTF8Bytes(@NonNull byte[] b, int p, int n) {
        if (b.length < p + n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if ((b[p + i] & 0xC0) == 128) continue;
            return false;
        }
        return true;
    }

    @NonNull
    public static byte[] getBytes(@Nullable String s) {
        int length;
        if (s == null || (length = s.length()) == 0) {
            return Emptys.EMPTY_BYTES;
        }
        byte[] b = new byte[length];
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c > '\u007f') {
                return s.getBytes(Charsets.UTF_8);
            }
            b[i] = (byte)(c & 0x7F);
        }
        return b;
    }

    @NonNull
    public static String toString(@NonNull byte[] b) {
        return new String(b, Charsets.UTF_8);
    }

    @NonNull
    public static String toString(@NonNull byte[] b, int offset, int length) {
        return new String(b, offset, length, Charsets.UTF_8);
    }

    public static char hexToChar(String hexChar) {
        return Utf8s.hexToChar(hexChar, true);
    }

    public static char hexToChar(String hex, boolean valid) {
        if (valid) {
            Preconditions.checkTrue(Regexps.match(ESCAPED_CHAR_REGEXP, hex), "illegal hex: {}", hex);
        }
        if (hex.startsWith("\\0")) {
            hex = hex.substring(2);
            int charCodePoint = Integer.parseInt(hex, 8);
            char c = (char)charCodePoint;
            return c;
        }
        if (hex.startsWith("\\x") || hex.startsWith("\\u")) {
            hex = hex.substring(2);
            int charCodePoint = Integer.parseInt(hex, 16);
            char c = (char)charCodePoint;
            return c;
        }
        throw new UnsupportedOperationException();
    }

    public static String decodeChars(String text) {
        return StringTemplates.format(text, ESCAPED_CHAR_REGEXP, new PlaceholderParser(){

            @Override
            public String parse(String variable) {
                return "" + Utf8s.hexToChar(variable, false);
            }
        });
    }

    public static String convertHexToUnicode(String text) {
        return Strings.replace(text, X16_CHAR_REGEXP, new Transformer<String, String>(){

            @Override
            public String transform(String hex) {
                return Utf8s.x2u(hex);
            }
        });
    }

    public static String x2u(String hex) {
        if (hex.startsWith("\\x") && hex.length() == 4) {
            return "\\u00" + hex.substring(2);
        }
        throw new UnsupportedOperationException("can't convert to unicode");
    }
}

