/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.pagination;

import com.jn.langx.util.pagination.PagingResult;

public class PagingRequest<E> {
    PagingResult<E> result;
    private Boolean count = null;
    private int pageNo = 1;
    private int pageSize;

    public boolean isEmptyRequest() {
        return this.pageSize == 0;
    }

    public boolean isGetAllRequest() {
        return this.pageSize < 0 && this.pageNo == 1;
    }

    public boolean isGetAllFromNonZeroOffsetRequest() {
        return this.pageSize < 0 && this.pageNo > 1;
    }

    public boolean isValidRequest() {
        return this.pageSize > 0 || this.isGetAllFromNonZeroOffsetRequest();
    }

    public PagingRequest limit(int pageNo, int pageSize) {
        return this.setPageNo(pageNo).setPageSize(pageSize);
    }

    public Boolean getCount() {
        return this.count;
    }

    public PagingRequest setCount(Boolean count) {
        this.count = count;
        return this;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public PagingRequest setPageNo(int pageNo) {
        this.pageNo = pageNo;
        return this;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public PagingRequest setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public long offset() {
        if (this.isEmptyRequest()) {
            return 0L;
        }
        if (this.isGetAllRequest()) {
            return 0L;
        }
        if (this.isGetAllFromNonZeroOffsetRequest()) {
            this.setPageSize(10);
        }
        if (this.isValidRequest()) {
            if (this.pageNo <= 0) {
                this.pageNo = 1;
            }
            return (this.pageNo - 1) * this.pageSize;
        }
        return -1L;
    }

    public PagingResult<E> getResult() {
        return this.result;
    }

    public void setResult(PagingResult<E> result) {
        this.result = result;
    }
}

