/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.pattern.regexp;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.pattern.AbstractPatternMatcher;
import com.jn.langx.util.regexp.Regexp;
import com.jn.langx.util.regexp.Regexps;

public class RegexpMatcher
extends AbstractPatternMatcher {
    private String pattern;
    private Regexp regexp;

    public RegexpMatcher() {
    }

    public RegexpMatcher(String pattern) {
        this(pattern, false);
    }

    public RegexpMatcher(String pattern, boolean ignoreCase) {
        this(pattern, ignoreCase, true);
    }

    public RegexpMatcher(String pattern, boolean ignoreCase, boolean trimPattern) {
        this.setPatternExpression(pattern);
        this.setIgnoreCase(ignoreCase);
        this.setTrimPattern(trimPattern);
    }

    @Override
    public void setPatternExpression(String patternExpression) {
        this.pattern = patternExpression;
    }

    @Override
    public Boolean matches(String string) {
        Preconditions.checkNotEmpty(string, "the string is null or empty");
        Preconditions.checkNotEmpty(this.pattern, "the regexp is null or empty");
        if (this.regexp == null) {
            if (this.trimPattern) {
                this.pattern = Strings.trim(this.pattern);
                if (Strings.isEmpty(this.pattern)) {
                    throw new IllegalArgumentException("illegal regexp pattern");
                }
            }
            this.regexp = Regexps.createRegexp(this.pattern, this.option);
        }
        if (this.trimPattern) {
            string = Strings.trim(string);
        }
        return this.regexp.matcher(string).matches();
    }
}

