/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.progress;

import com.jn.langx.AbstractNameable;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.NotEmpty;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Maths;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.id.UuidGenerator;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.progress.ProgressTracer;
import org.slf4j.Logger;

public class ProgressSource
extends AbstractNameable {
    private static final Logger logger = Loggers.getLogger(ProgressSource.class);
    private static final String SEP = "__PROGRESS__";
    @NotEmpty
    private String eventDomain;
    @NotEmpty
    private String id;
    private long progress;
    private long expected;
    @NonNull
    private State state;
    @Nullable
    private ProgressTracer tracer;
    @Nullable
    private Object ref;

    public ProgressSource(long expected) {
        this(UuidGenerator.INSTANCE.get(), expected);
    }

    public ProgressSource(String id, long expected) {
        this("common", id, expected);
    }

    public ProgressSource(String eventDomain, String id) {
        this(eventDomain, id, -1L);
    }

    public ProgressSource(String eventDomain, String id, long expected) {
        this(eventDomain, id, expected, null, null);
    }

    public ProgressSource(String eventDomain, String id, long expected, Object ref, ProgressTracer tracer) {
        Preconditions.checkNotNullArgument(eventDomain, "eventDomain");
        this.eventDomain = eventDomain;
        Preconditions.checkNotNullArgument(id, "id");
        this.id = id;
        this.setName(this.eventDomain + SEP + this.id);
        this.expected = expected;
        this.progress = 0L;
        this.state = State.INITIALED;
        this.ref = ref;
        this.tracer = tracer;
    }

    public void start() {
        if (this.state == State.INITIALED) {
            if (this.tracer != null) {
                this.tracer.begin(this);
            }
            this.state = State.UPDATING;
            if (logger.isDebugEnabled()) {
                logger.debug(this.toString());
            }
        }
    }

    public void forward(long increment) {
        this.update(this.getProgress() + increment);
    }

    public void update(long progress) {
        this.update(progress, -1L);
    }

    public void update(long progress, long expected) {
        Preconditions.checkState(this.state == State.UPDATING, "not in updating: " + this.getName());
        if (progress > 0L) {
            this.progress = progress;
        }
        if (expected > 0L) {
            Preconditions.checkArgument(expected >= this.progress);
            this.expected = expected;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.toString());
        }
        if (this.tracer != null) {
            this.tracer.updateProcess(this);
        }
    }

    public void finish() {
        if (this.state != State.FINISHED) {
            this.state = State.FINISHED;
            if (logger.isDebugEnabled()) {
                logger.debug(this.toString());
            }
            if (this.tracer != null) {
                this.tracer.finish(this);
            }
        }
    }

    public boolean isSuccess() {
        return this.finished() && (this.getExpected() < 0L || this.getProgress() == this.getExpected());
    }

    public State getState() {
        return this.state;
    }

    public boolean started() {
        return this.state != State.INITIALED;
    }

    public Object getRef() {
        return this.ref;
    }

    public boolean finished() {
        return this.state == State.FINISHED;
    }

    public long getProgress() {
        return this.progress;
    }

    public long getExpected() {
        return this.expected;
    }

    public String getEventDomain() {
        return this.eventDomain;
    }

    public double percent() {
        return this.percent(0);
    }

    public String percentAsString() {
        return this.percentAsString(0);
    }

    public double percent(int precision) {
        double p = 1.0 * (double)this.progress / (double)this.expected * 100.0;
        p = Maths.formatPrecision(p, precision);
        return p;
    }

    public String percentAsString(int precision) {
        double p = 1.0 * (double)this.progress / (double)this.expected * 100.0;
        String string = Maths.formatPrecisionAsString(p, precision);
        return string + "%";
    }

    public String toString() {
        return StringTemplates.formatWithPlaceholder("progress trace: {}, current: {}, expected: {}, percent: {}, state: {}", new Object[]{this.getName(), this.getProgress(), this.getExpected(), this.percentAsString(), this.getState()});
    }

    private static enum State {
        INITIALED,
        UPDATING,
        FINISHED;

    }
}

