/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.regexp;

import com.jn.langx.util.Objs;

public class Option {
    public static final int CASE_INSENSITIVE = 2;
    public static final int MULTILINE = 8;
    private boolean ignoreCase = false;
    private boolean multiline = false;
    private boolean global = false;
    public static final Option DEFAULT = new Option();

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    public static int toFlags(Option option) {
        int flags = 0;
        if (option.multiline) {
            flags |= 8;
        }
        if (option.isIgnoreCase()) {
            flags |= 2;
        }
        return flags;
    }

    public static final Option buildOption(int flags) {
        Option option = new Option();
        option.setMultiline(Option.has(flags, 8));
        option.setIgnoreCase(Option.has(flags, 2));
        return option;
    }

    public final int toFlags() {
        return Option.toFlags(this);
    }

    public static boolean has(int flags, int f) {
        return (flags & f) != 0;
    }

    public static Option fromJavaScriptFlags(String flags) {
        Option opt = new Option();
        block5: for (int i = 0; i < flags.length(); ++i) {
            char ch = flags.charAt(i);
            switch (ch) {
                case 'g': {
                    opt.setGlobal(true);
                    continue block5;
                }
                case 'i': {
                    opt.setIgnoreCase(true);
                    continue block5;
                }
                case 'm': {
                    opt.setMultiline(true);
                    continue block5;
                }
            }
        }
        return opt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Option option = (Option)o;
        return this.ignoreCase == option.ignoreCase && this.multiline == option.multiline && this.global == option.global;
    }

    public int hashCode() {
        return Objs.hash(this.ignoreCase, this.multiline, this.global);
    }
}

