/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.timing.timer;

import com.jn.langx.util.concurrent.executor.ImmediateExecutor;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.timing.timer.Timeout;
import com.jn.langx.util.timing.timer.Timer;
import com.jn.langx.util.timing.timer.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.slf4j.Logger;

public abstract class AbstractTimeout
implements Timeout,
Runnable {
    protected final Timer timer;
    protected final TimerTask task;
    protected final long deadline;
    private volatile int state = 0;
    private static final AtomicIntegerFieldUpdater<AbstractTimeout> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(AbstractTimeout.class, "state");

    protected AbstractTimeout(Timer timer, TimerTask task, long deadline) {
        this.timer = timer;
        this.task = task;
        this.deadline = deadline;
    }

    public boolean compareAndSetState(int expected, int state) {
        return STATE_UPDATER.compareAndSet(this, expected, state);
    }

    public int state() {
        return this.state;
    }

    @Override
    public boolean isCancelled() {
        return this.state() == 1;
    }

    @Override
    public boolean isExpired() {
        return this.state() == 2;
    }

    public void executeTask() {
        Executor executor = this.timer.getTaskExecutor();
        if (executor == null) {
            executor = ImmediateExecutor.INSTANCE;
        }
        executor.execute(this);
    }

    @Override
    public void run() {
        block2: {
            try {
                this.task.run(this);
            }
            catch (Throwable t) {
                Logger logger = Loggers.getLogger(this.getClass());
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("An exception was thrown by " + TimerTask.class.getSimpleName() + '.', t);
            }
        }
    }

    @Override
    public Timer timer() {
        return this.timer;
    }

    @Override
    public TimerTask task() {
        return this.task;
    }
}

