/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.jsqlparser.expression;

import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Function;
import com.jn.sqlhelper.dialect.expression.ListExpression;
import com.jn.sqlhelper.dialect.expression.SQLExpression;
import com.jn.sqlhelper.jsqlparser.expression.ExpressionConverter;
import com.jn.sqlhelper.jsqlparser.expression.ExpressionConverterRegistry;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;

public class ExpressionConverters {
    public static Expression toJSqlParserExpression(SQLExpression expression) {
        ExpressionConverterRegistry registry = ExpressionConverterRegistry.getInstance();
        ExpressionConverter converter = registry.getExpressionConverterByStandardExpressionClass(expression.getClass());
        return converter.toJSqlParserExpression(expression);
    }

    public static ExpressionList toJSqlParserExpressionList(final ListExpression expression) {
        List expressions = Pipeline.of((Iterable)expression.getExpressions()).map((Function)new Function<SQLExpression, Expression>(){

            public Expression apply(SQLExpression input) {
                return ExpressionConverters.toJSqlParserExpression((SQLExpression)expression);
            }
        }).asList();
        ExpressionList result = new ExpressionList();
        result.setExpressions(expressions);
        return result;
    }

    public final SQLExpression fromJSqlParserExpression(Expression expression) {
        ExpressionConverterRegistry registry = ExpressionConverterRegistry.getInstance();
        ExpressionConverter converter = registry.getExpressionConverterByJSqlParserExpressionClass(expression.getClass());
        return converter.fromJSqlParserExpression(expression);
    }
}

