/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.compress.gzip;

import com.github.fartherp.framework.compress.CommonCompress;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.io.IOUtils;

public class GzipCompress
extends CommonCompress {
    private CommonCompress commonCompress;

    public GzipCompress(CommonCompress commonCompress) {
        this.commonCompress = commonCompress;
    }

    public void compress() {
        if (2 == this.commonCompress.getFlag()) {
            this.startCompress(this.commonCompress.getSourceFile(), this.commonCompress.getHttpServletResponse());
        } else {
            this.startCompress(this.commonCompress.getSourceFile(), this.commonCompress.getTargetFile());
        }
    }

    public String unCompress() {
        File target = this.commonCompress.getTargetFile();
        this.startUnCompress(this.commonCompress.getSourceFile(), target);
        return target.getAbsolutePath();
    }

    public void startCompress(File sourceFile, HttpServletResponse httpServletResponse) {
        GzipCompressorOutputStream outputStream = null;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(sourceFile);
            outputStream = new GzipCompressorOutputStream((OutputStream)httpServletResponse.getOutputStream());
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("TAR \u538b\u7f29\u6587\u4ef6\u6216\u6587\u4ef6\u5939\u9519\u8bef", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    public void startCompress(File sourceFile, File targetFile) {
        GzipCompressorOutputStream outputStream = null;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(sourceFile);
            outputStream = new GzipCompressorOutputStream((OutputStream)new FileOutputStream(targetFile));
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("TAR \u538b\u7f29\u6587\u4ef6\u6216\u6587\u4ef6\u5939\u9519\u8bef", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    protected void startUnCompress(File sourceFile, File target) {
        GzipCompressorInputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            inputStream = new GzipCompressorInputStream((InputStream)new FileInputStream(sourceFile));
            outputStream = new FileOutputStream(target);
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("TAR \u89e3\u538b\u7f29\u6587\u4ef6\u6216\u6587\u4ef6\u5939\u9519\u8bef", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((InputStream)inputStream);
    }
}

