/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.compress;

import com.github.fartherp.framework.common.util.FileUtilies;
import com.github.fartherp.framework.compress.Compress;
import java.io.File;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public abstract class CommonCompress
implements Compress {
    protected int flag;
    protected CommonCompress commonCompress;
    protected String type;
    protected String suffix;
    protected String source;
    protected String target;
    protected File sourceFile;
    protected File targetFile;
    protected HttpServletResponse httpServletResponse;

    public void compress() {
        if (2 != this.flag) {
            this.validation(false);
        }
        this.setFlag(this.flag);
        this.commonCompress.compress();
    }

    public String unCompress() {
        this.validation(true);
        return this.commonCompress.unCompress();
    }

    private void validation(boolean flag) {
        String sourcePath = this.getSource();
        String targetPath = this.getTarget();
        if (StringUtils.isBlank((String)sourcePath)) {
            throw new RuntimeException("source file name[" + sourcePath + "] no exist");
        }
        String suffix = this.getSuffix();
        if (!flag && targetPath != null && !targetPath.endsWith(suffix)) {
            throw new RuntimeException("current class compress type [" + suffix + "] source file suffix error");
        }
        File source = this.getSourceFile();
        if (!source.exists()) {
            throw new RuntimeException("source file name[" + sourcePath + "] no exist");
        }
        this.dealTarget(flag);
        if (flag && "bz2".equals(suffix) && (StringUtils.isBlank((String)targetPath) || targetPath.startsWith(source.getParent()) || source.getParent().startsWith(targetPath))) {
            throw new RuntimeException("bz2\u540e\u7f00\u5fc5\u987b\u7ed9\u51fa\u8f93\u51fa\u76ee\u5f55\u6216\u76ee\u6807\u76ee\u5f55\u4e0e\u6e90\u6587\u4ef6\u76ee\u5f55\u4e0d\u80fd\u5728\u4e00\u4e2a\u7236\u76ee\u5f55\u4e0a");
        }
    }

    private void dealTarget(boolean flag) {
        File source = this.getSourceFile();
        if (StringUtils.isBlank((String)this.getTarget())) {
            this.setTarget(source.getParent());
            File target = null;
            if (flag) {
                target = source.getParentFile();
            } else {
                String fileName = source.isDirectory() ? source.getName() : StringUtils.substringBeforeLast((String)source.getName(), (String)".");
                target = new File(source.getParentFile(), fileName + "." + this.getSuffix());
            }
            this.setTargetFile(target);
        } else {
            File target = this.getTargetFile();
            if (flag && target.getName().endsWith(this.getSuffix())) {
                throw new RuntimeException(" target must is dir not file ");
            }
            if (target.getName().endsWith(this.getSuffix())) {
                if (target.exists()) {
                    throw new RuntimeException("target file exist");
                }
                this.setTarget(target.getAbsolutePath());
                this.setTargetFile(target);
            } else if (!target.exists()) {
                File file = new File(target, File.separator);
                file.mkdirs();
                this.setTarget(target.getAbsolutePath());
                this.setTargetFile(target);
            }
        }
    }

    public CommonCompress source(String source) {
        this.setSource(source);
        this.setSourceFile(new File(source));
        return this;
    }

    public CommonCompress target(String target) {
        this.setTarget(target);
        this.setTargetFile(new File(target));
        return this;
    }

    public CommonCompress response(HttpServletRequest request, HttpServletResponse response) {
        this.response(request, response, new Date().getTime() + "");
        return this;
    }

    public CommonCompress response(HttpServletRequest request, HttpServletResponse response, String fileName) {
        this.flag = 2;
        response.reset();
        response.setContentType("application/octet-stream;charset=GBK");
        String filename = FileUtilies.getFileName((String)fileName, (HttpServletRequest)request);
        response.setHeader("content-disposition", "attachment; filename=" + filename + "." + this.getSuffix());
        this.setHttpServletResponse(response);
        return this;
    }

    public int getFlag() {
        return this.flag;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(File sourceFile) {
        this.sourceFile = sourceFile;
    }

    public File getTargetFile() {
        return this.targetFile;
    }

    public void setTargetFile(File targetFile) {
        this.targetFile = targetFile;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.httpServletResponse;
    }

    public void setHttpServletResponse(HttpServletResponse httpServletResponse) {
        this.httpServletResponse = httpServletResponse;
    }
}

