/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.compress.bzip2;

import com.github.fartherp.framework.compress.CommonCompress;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.io.IOUtils;

public class BZip2Compress
extends CommonCompress {
    public BZip2Compress(CommonCompress commonCompress) {
        this.commonCompress = commonCompress;
    }

    public void compress() {
        if (2 == this.commonCompress.getFlag()) {
            this.startCompress(this.commonCompress.getSourceFile(), this.commonCompress.getHttpServletResponse());
        } else {
            this.startCompress(this.commonCompress.getSourceFile(), this.commonCompress.getTargetFile());
        }
    }

    public String unCompress() {
        File target = this.commonCompress.getTargetFile();
        this.startUnCompress(this.commonCompress.getSourceFile(), target);
        return target.getAbsolutePath();
    }

    public void startCompress(File sourceFile, HttpServletResponse httpServletResponse) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(sourceFile);
            this.doCompress(inputStream, (OutputStream)httpServletResponse.getOutputStream());
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("ZIP \u538b\u7f29\u6587\u4ef6\u6216\u6587\u4ef6\u5939\u9519\u8bef", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    public void startCompress(File sourceFile, File targetFile) {
        FileInputStream inputStream = null;
        BZip2CompressorOutputStream outputStream = null;
        try {
            outputStream = new BZip2CompressorOutputStream((OutputStream)new FileOutputStream(targetFile));
            inputStream = new FileInputStream(sourceFile);
            this.doCompress(inputStream, (OutputStream)outputStream);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("ZIP \u538b\u7f29\u6587\u4ef6\u6216\u6587\u4ef6\u5939\u9519\u8bef", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    public void doCompress(InputStream inputStream, OutputStream outputStream) throws Exception {
        IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
    }

    protected void startUnCompress(File sourceFile, File target) {
        FileOutputStream outputStream = null;
        BZip2CompressorInputStream inputStream = null;
        try {
            outputStream = new FileOutputStream(target);
            inputStream = new BZip2CompressorInputStream((InputStream)new FileInputStream(sourceFile));
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("TAR \u89e3\u538b\u7f29\u6587\u4ef6\u6216\u6587\u4ef6\u5939\u9519\u8bef", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly((OutputStream)outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
    }
}

