/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.compress.jar;

import com.github.fartherp.framework.compress.CommonCompress;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.apache.commons.io.IOUtils;

public class JarCompress
extends CommonCompress {
    public JarCompress(CommonCompress commonCompress) {
        this.commonCompress = commonCompress;
    }

    public void compress() {
        this.startCompress(this.commonCompress.getSourceFile(), this.commonCompress.getTargetFile());
    }

    public String unCompress() {
        File target = this.commonCompress.getTargetFile();
        this.startUnCompress(this.commonCompress.getSourceFile(), target);
        return target.getAbsolutePath();
    }

    public void startCompress(File sourceFile, File targetFile) {
        JarOutputStream jarOutputStream = null;
        try {
            jarOutputStream = new JarOutputStream(new FileOutputStream(targetFile));
            this.doCompress(jarOutputStream, sourceFile, null);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(jarOutputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)jarOutputStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doCompress(JarOutputStream outputStream, File sourceFile, String path) throws Exception {
        if (sourceFile.isDirectory()) {
            String subPath;
            String[] dirList = sourceFile.list();
            String string = subPath = path == null ? "" : path + sourceFile.getName() + File.separator;
            if (path != null) {
                JarEntry je = new JarEntry(subPath);
                je.setTime(sourceFile.lastModified());
                outputStream.putNextEntry(je);
                outputStream.flush();
                outputStream.closeEntry();
            }
            String[] arr$ = dirList;
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                String dir = arr$[i$];
                File f = new File(sourceFile, dir);
                this.doCompress(outputStream, f, subPath);
                ++i$;
            }
            return;
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(sourceFile);
            JarEntry jarEntry = new JarEntry(path + sourceFile.getName());
            jarEntry.setTime(sourceFile.lastModified());
            outputStream.putNextEntry(jarEntry);
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            outputStream.flush();
            outputStream.closeEntry();
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    protected void startUnCompress(File sourceFile, File target) {
        JarInputStream inputStream = null;
        try {
            JarEntry entry;
            inputStream = new JarInputStream(new FileInputStream(sourceFile));
            while ((entry = inputStream.getNextJarEntry()) != null) {
                int count;
                if (entry.isDirectory()) {
                    File dir = new File(target, entry.getName());
                    dir.mkdir();
                    if (entry.getTime() == -1L) continue;
                    dir.setLastModified(entry.getTime());
                    continue;
                }
                byte[] data = new byte[1024];
                File destFile = new File(target, entry.getName());
                BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(destFile), 1024);
                while ((count = inputStream.read(data, 0, 1024)) != -1) {
                    outputStream.write(data, 0, count);
                }
                outputStream.flush();
                IOUtils.closeQuietly((OutputStream)outputStream);
                if (entry.getTime() == -1L) continue;
                destFile.setLastModified(entry.getTime());
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }
}

