/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.compress.tar;

import com.github.fartherp.framework.compress.CommonCompress;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.IOUtils;

public class TarCompress
extends CommonCompress {
    public TarCompress(CommonCompress commonCompress) {
        this.commonCompress = commonCompress;
    }

    public void compress() {
        if (2 == this.commonCompress.getFlag()) {
            this.startCompress(this.commonCompress.getSourceFile(), this.commonCompress.getHttpServletResponse());
        } else {
            this.startCompress(this.commonCompress.getSourceFile(), this.commonCompress.getTargetFile());
        }
    }

    public String unCompress() {
        File target = this.commonCompress.getTargetFile();
        this.startUnCompress(this.commonCompress.getSourceFile(), target);
        return target.getAbsolutePath();
    }

    public void startCompress(File sourceFile, HttpServletResponse httpServletResponse) {
        TarArchiveOutputStream outputStream = null;
        try {
            outputStream = new TarArchiveOutputStream((OutputStream)httpServletResponse.getOutputStream());
            this.doCompress(outputStream, sourceFile, sourceFile.getName());
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("TAR \u538b\u7f29\u6587\u4ef6\u6216\u6587\u4ef6\u5939\u9519\u8bef", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    public void startCompress(File sourceFile, File targetFile) {
        TarArchiveOutputStream outputStream = null;
        try {
            outputStream = new TarArchiveOutputStream((OutputStream)new FileOutputStream(targetFile));
            outputStream.setBigNumberMode(1);
            outputStream.setLongFileMode(2);
            this.doCompress(outputStream, sourceFile, sourceFile.getName());
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("TAR \u538b\u7f29\u6587\u4ef6\u6216\u6587\u4ef6\u5939\u9519\u8bef", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    public void doCompress(TarArchiveOutputStream tarArchiveOutputStream, File sourceFile, String path) throws Exception {
        if (sourceFile.isDirectory()) {
            File[] listFiles = sourceFile.listFiles();
            if (listFiles.length < 1) {
                TarArchiveEntry entry = new TarArchiveEntry(path + File.separator);
                tarArchiveOutputStream.putArchiveEntry((ArchiveEntry)entry);
                tarArchiveOutputStream.closeArchiveEntry();
            }
            path = path.equals("") ? "" : path + File.separator;
            for (int i = 0; i < listFiles.length; ++i) {
                this.doCompress(tarArchiveOutputStream, listFiles[i], path + listFiles[i].getName());
            }
        } else {
            int count;
            TarArchiveEntry tarArchiveEntry = new TarArchiveEntry(path);
            tarArchiveEntry.setSize(sourceFile.length());
            tarArchiveOutputStream.putArchiveEntry((ArchiveEntry)tarArchiveEntry);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(sourceFile));
            byte[] bytes = new byte[1024];
            while ((count = bufferedInputStream.read(bytes, 0, 1024)) != -1) {
                tarArchiveOutputStream.write(bytes, 0, count);
            }
            bufferedInputStream.close();
            tarArchiveOutputStream.closeArchiveEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void startUnCompress(File sourceFile, File target) {
        TarArchiveInputStream inputStream = null;
        try {
            inputStream = new TarArchiveInputStream((InputStream)new FileInputStream(sourceFile));
            TarArchiveEntry entry = null;
            while (null != (entry = inputStream.getNextTarEntry())) {
                String path = target + File.separator + entry.getName();
                File dirFile = new File(path);
                if (entry.isDirectory()) {
                    dirFile.mkdirs();
                    continue;
                }
                if (!dirFile.getParentFile().exists()) {
                    dirFile.getParentFile().mkdirs();
                }
                BufferedOutputStream outputStream = null;
                try {
                    outputStream = new BufferedOutputStream(new FileOutputStream(dirFile));
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
                catch (IOException e) {
                    IOUtils.closeQuietly(outputStream);
                    continue;
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(outputStream);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((OutputStream)outputStream);
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("TAR \u89e3\u538b\u7f29\u6587\u4ef6\u6216\u6587\u4ef6\u5939\u9519\u8bef", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }
}

