/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.compress.zip;

import com.github.fartherp.framework.compress.CommonCompress;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.io.IOUtils;

public class ZipCompress
extends CommonCompress {
    public ZipCompress(CommonCompress commonCompress) {
        this.commonCompress = commonCompress;
    }

    public void compress() {
        if (2 == this.commonCompress.getFlag()) {
            this.startCompress(this.commonCompress.getSourceFile(), this.commonCompress.getHttpServletResponse());
        } else {
            this.startCompress(this.commonCompress.getSourceFile(), this.commonCompress.getTargetFile());
        }
    }

    public String unCompress() {
        File target = this.commonCompress.getTargetFile();
        this.startUnCompress(this.commonCompress.getSourceFile(), target);
        return target.getAbsolutePath();
    }

    public void startCompress(File sourceFile, File targetFile) {
        ZipOutputStream outputStream = null;
        try {
            outputStream = new ZipOutputStream(new BufferedOutputStream(new CheckedOutputStream(new FileOutputStream(targetFile), new CRC32())));
            this.doCompress(outputStream, sourceFile, sourceFile.getName());
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("ZIP \u538b\u7f29\u6587\u4ef6\u6216\u6587\u4ef6\u5939\u9519\u8bef", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    public void startCompress(File sourceFile, HttpServletResponse httpServletResponse) {
        ZipOutputStream outputStream = null;
        try {
            outputStream = new ZipOutputStream(new BufferedOutputStream(new CheckedOutputStream((OutputStream)httpServletResponse.getOutputStream(), new CRC32())));
            this.doCompress(outputStream, sourceFile, sourceFile.getName());
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("ZIP \u538b\u7f29\u6587\u4ef6\u6216\u6587\u4ef6\u5939\u9519\u8bef", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void doCompress(ZipOutputStream outputStream, File sourceFile, String path) {
        FileInputStream inputStream;
        block7: {
            inputStream = null;
            try {
                if (sourceFile.isDirectory()) {
                    File[] listFiles = sourceFile.listFiles();
                    outputStream.putNextEntry(new ZipEntry(path + File.separator));
                    String string = path = path.equals("") ? "" : path + File.separator;
                    if (null != listFiles) {
                        for (File file : listFiles) {
                            this.doCompress(outputStream, file, path + file.getName());
                        }
                    }
                    break block7;
                }
                outputStream.putNextEntry(new ZipEntry(path));
                inputStream = new FileInputStream(sourceFile);
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            catch (Exception e) {
                IOUtils.closeQuietly(inputStream);
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void startUnCompress(File sourceFile, File target) {
        ZipArchiveInputStream is = null;
        try {
            is = new ZipArchiveInputStream((InputStream)new BufferedInputStream(new FileInputStream(sourceFile)));
            ZipArchiveEntry entry = null;
            while ((entry = is.getNextZipEntry()) != null) {
                if (entry.isDirectory()) {
                    File f = new File(target, entry.getName());
                    if (f.exists()) continue;
                    f.mkdirs();
                    continue;
                }
                BufferedOutputStream os = null;
                try {
                    File file = new File(target, entry.getName());
                    os = new BufferedOutputStream(new FileOutputStream(file));
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(os);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)os);
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("ZIP \u89e3\u538b\u7f29\u6587\u4ef6\u6216\u6587\u4ef6\u5939\u9519\u8bef", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
    }
}

