/*
 * Decompiled with CFR 0.152.
 */
package com.github.plugin.fixedvalueplugin;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JEnumConstant;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.EnumConstantOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSTerm;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.xml.sax.ErrorHandler;

public class FixedValuePlugin
extends Plugin {
    private static final String OPTION_NAME = "Xfixed-value";

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return "  -Xfixed-value    : enable rewriting of classes to set default values for fields as specified in XML schema";
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) {
        for (ClassOutline co : outline.getClasses()) {
            JFieldVar dtf = null;
            for (FieldOutline f : co.getDeclaredFields()) {
                String typeFullName;
                XSElementDecl element;
                XSTerm term;
                CPropertyInfo fieldInfo = f.getPropertyInfo();
                if (!(fieldInfo.getSchemaComponent() instanceof XSParticle) || !(term = ((XSParticle)fieldInfo.getSchemaComponent()).getTerm()).isElementDecl() || (element = term.asElementDecl()).getFixedValue() == null) continue;
                String fixedValue = element.getFixedValue().value;
                Map fields = co.implClass.fields();
                JFieldVar var = (JFieldVar)fields.get(fieldInfo.getName(false));
                JType type = f.getRawType();
                if (type.isPrimitive()) {
                    type = type.boxify();
                }
                if ("java.lang.String".equals(typeFullName = type.fullName())) {
                    var.init(JExpr.lit((String)fixedValue));
                    if (!opt.verbose) continue;
                    System.out.println("[INFO] Initializing String variable " + fieldInfo.displayName() + " to \"" + fixedValue + "\"");
                    continue;
                }
                if ("java.lang.Boolean".equals(typeFullName)) {
                    var.init(JExpr.lit((boolean)Boolean.valueOf(fixedValue)));
                    if (!opt.verbose) continue;
                    System.out.println("[INFO] Initializing Boolean variable " + fieldInfo.displayName() + " to " + fixedValue + "");
                    continue;
                }
                if ("java.lang.Byte".equals(typeFullName) || "java.lang.Short".equals(typeFullName) || "java.lang.Integer".equals(typeFullName)) {
                    var.init(JExpr.lit((int)Integer.valueOf(fixedValue)));
                    if (!opt.verbose) continue;
                    System.out.println("[INFO] Initializing Integer variable " + fieldInfo.displayName() + " to " + fixedValue + "");
                    continue;
                }
                if ("java.lang.Long".equals(typeFullName)) {
                    var.init(JExpr.lit((long)Long.valueOf(fixedValue)));
                    if (!opt.verbose) continue;
                    System.out.println("[INFO] Initializing Long variable " + fieldInfo.displayName() + " to " + fixedValue + "");
                    continue;
                }
                if ("java.lang.Float".equals(typeFullName)) {
                    var.init(JExpr.lit((float)Float.valueOf(fixedValue).floatValue()));
                    if (!opt.verbose) continue;
                    System.out.println("[INFO] Initializing Float variable " + fieldInfo.displayName() + " to " + fixedValue + "");
                    continue;
                }
                if ("java.lang.Single".equals(typeFullName) || "java.lang.Double".equals(typeFullName)) {
                    var.init(JExpr.lit((double)Double.valueOf(fixedValue)));
                    if (!opt.verbose) continue;
                    System.out.println("[INFO] Initializing Double variable " + fieldInfo.displayName() + " to " + fixedValue + "");
                    continue;
                }
                if ("javax.xml.datatype.XMLGregorianCalendar".equals(typeFullName)) {
                    if (dtf == null && (dtf = this.installDtF(co.implClass)) == null) continue;
                    var.init((JExpression)JExpr.invoke(dtf, (String)"newXMLGregorianCalendar").arg(fixedValue));
                    if (!opt.verbose) continue;
                    System.out.println("[INFO] Initializing XMLGregorianCalendar variable " + fieldInfo.displayName() + " with value of " + fixedValue);
                    continue;
                }
                if (type instanceof JDefinedClass && ((JDefinedClass)type).getClassType() == ClassType.ENUM) {
                    JEnumConstant constant = this.findEnumConstant(type, fixedValue, outline);
                    if (constant == null) continue;
                    var.init((JExpression)constant);
                    if (!opt.verbose) continue;
                    System.out.println("[INFO] Initializing enum variable " + fieldInfo.displayName() + " with constant " + constant.getName());
                    continue;
                }
                System.out.println("[WARN] Did not create default value for field " + fieldInfo.displayName() + ". Don't know how to create default value expression for fields of type " + typeFullName + ". Default value of \"" + fixedValue + "\" specified in schema");
            }
        }
        return true;
    }

    private JEnumConstant findEnumConstant(JType enumType, String enumStringValue, Outline outline) {
        for (EnumOutline eo : outline.getEnums()) {
            if (eo.clazz != enumType) continue;
            for (EnumConstantOutline eco : eo.constants) {
                if (!eco.target.getLexicalValue().equals(enumStringValue)) continue;
                return eco.constRef;
            }
            System.out.println("[WARN] Could not find EnumConstant for value: " + enumStringValue);
            return null;
        }
        System.out.println("[WARN] Could not find Enum class for type: " + enumType.fullName());
        return null;
    }

    private JFieldVar installDtF(JDefinedClass parentClass) {
        try {
            JCodeModel cm = parentClass.owner();
            JClass dtfClass = cm.ref(DatatypeFactory.class);
            JFieldVar dtf = parentClass.field(28, (JType)dtfClass, "DATATYPE_FACTORY");
            JBlock si = parentClass.init();
            JTryBlock tryBlock = si._try();
            tryBlock.body().assign((JAssignmentTarget)dtf, (JExpression)dtfClass.staticInvoke("newInstance"));
            JCatchBlock catchBlock = tryBlock._catch(cm.ref(DatatypeConfigurationException.class));
            JVar ex = catchBlock.param("ex");
            JClass runtimeException = cm.ref(RuntimeException.class);
            catchBlock.body()._throw((JExpression)JExpr._new((JClass)runtimeException).arg("Unable to initialize DatatypeFactory").arg((JExpression)ex));
            return dtf;
        }
        catch (Exception e) {
            System.out.println("[ERROR] Failed to create code");
            e.printStackTrace();
            return null;
        }
    }
}

