/*
 * Decompiled with CFR 0.152.
 */
package fs2.kafka.vulcan.testkit;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.unsafe.implicits$;
import fs2.kafka.internal.syntax;
import fs2.kafka.internal.syntax$;
import fs2.kafka.vulcan.SchemaRegistryClientSettings;
import fs2.kafka.vulcan.testkit.AssertableCompatibilityChecker;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collection;
import munit.Assertions;
import munit.Location;
import munit.Suite;
import org.apache.avro.Schema;
import org.apache.avro.SchemaCompatibility;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import vulcan.Codec;

public interface SchemaSuite {
    public static Schema fs2$kafka$vulcan$testkit$SchemaSuite$$codecAsSchema$(SchemaSuite $this, Codec codec) {
        return $this.fs2$kafka$vulcan$testkit$SchemaSuite$$codecAsSchema(codec);
    }

    default public <A> Schema fs2$kafka$vulcan$testkit$SchemaSuite$$codecAsSchema(Codec<A> codec) {
        return (Schema)codec.schema().fold((Function1 & Serializable)e -> {
            throw ((Assertions)this).fail(e.message(), ((Assertions)this).fail$default$2(), new Location("/home/runner/work/fs2-kafka/fs2-kafka/modules/vulcan-testkit-munit/src/main/scala/fs2/kafka/vulcan/testkit/SchemaSuite.scala", 40));
        }, (Function1 & Serializable)ok -> ok);
    }

    public static String fs2$kafka$vulcan$testkit$SchemaSuite$$renderIncompatibilities$(SchemaSuite $this, List incompatibilities) {
        return $this.fs2$kafka$vulcan$testkit$SchemaSuite$$renderIncompatibilities((List<SchemaCompatibility.Incompatibility>)incompatibilities);
    }

    default public String fs2$kafka$vulcan$testkit$SchemaSuite$$renderIncompatibilities(List<SchemaCompatibility.Incompatibility> incompatibilities) {
        return new StringBuilder(26).append("Schema incompatibilities:\n").append(((List)incompatibilities.zipWithIndex()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                SchemaCompatibility.Incompatibility incompatibility = (SchemaCompatibility.Incompatibility)tuple2._1();
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(95).append(i + 1).append(") ").append(incompatibility.getType()).append(" - ").append(incompatibility.getMessage()).append("\n           |At ").append(incompatibility.getLocation()).append("\n           |Reader schema fragment: ").append(incompatibility.getReaderFragment().toString(true)).append("\n           |Writer schema fragment: ").append(incompatibility.getWriterFragment().toString(true)).toString()));
            }
            throw new MatchError((Object)tuple2);
        }).mkString("\n-----\n")).toString();
    }

    public static Suite.Fixture compatibilityChecker$(SchemaSuite $this, SchemaRegistryClientSettings clientSettings, String name) {
        return $this.compatibilityChecker((SchemaRegistryClientSettings<IO>)clientSettings, name);
    }

    default public Suite.Fixture<AssertableCompatibilityChecker<IO>> compatibilityChecker(SchemaRegistryClientSettings<IO> clientSettings, String name) {
        return new Suite.Fixture<AssertableCompatibilityChecker<IO>>(clientSettings, name, this){
            private final SchemaRegistryClientSettings clientSettings$2;
            private AssertableCompatibilityChecker checker;
            private final /* synthetic */ SchemaSuite $outer;
            {
                this.clientSettings$2 = clientSettings$1;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super((Suite)$outer, name$1);
                this.checker = null;
            }

            public AssertableCompatibilityChecker apply() {
                return this.checker;
            }

            public void beforeAll() {
                this.checker = (AssertableCompatibilityChecker)this.$outer.newCompatibilityChecker((SchemaRegistryClientSettings<IO>)this.clientSettings$2).unsafeRunSync(implicits$.MODULE$.global());
            }
        };
    }

    public static String compatibilityChecker$default$2$(SchemaSuite $this) {
        return $this.compatibilityChecker$default$2();
    }

    default public String compatibilityChecker$default$2() {
        return "schema-compatibility-checker";
    }

    public static IO newCompatibilityChecker$(SchemaSuite $this, SchemaRegistryClientSettings clientSettings) {
        return $this.newCompatibilityChecker((SchemaRegistryClientSettings<IO>)clientSettings);
    }

    default public IO<AssertableCompatibilityChecker<IO>> newCompatibilityChecker(SchemaRegistryClientSettings<IO> clientSettings) {
        return ((IO)clientSettings.createSchemaRegistryClient()).map((Function1 & Serializable)client -> new AssertableCompatibilityChecker<IO>(client, this){
            private final SchemaRegistryClient client$1;
            private final /* synthetic */ SchemaSuite $outer;
            {
                this.client$1 = client$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            private IO registrySchema(String subject) {
                return IO$.MODULE$.delay(() -> this.registrySchema$$anonfun$1(subject)).flatMap((Function1 & Serializable)metadata -> IO$.MODULE$.delay(() -> this.registrySchema$$anonfun$2$$anonfun$1(metadata)).map(SchemaSuite::fs2$kafka$vulcan$testkit$SchemaSuite$$anon$2$$_$registrySchema$$anonfun$2$$anonfun$2));
            }

            public IO checkReaderCompatibility(Codec reader, String writerSubject) {
                Schema vulcanSchema = this.$outer.fs2$kafka$vulcan$testkit$SchemaSuite$$codecAsSchema(reader);
                return this.registrySchema(writerSubject).map(arg_0 -> SchemaSuite.fs2$kafka$vulcan$testkit$SchemaSuite$$anon$2$$_$checkReaderCompatibility$$anonfun$1(vulcanSchema, arg_0));
            }

            public IO checkWriterCompatibility(Codec writer, String readerSubject) {
                Schema vulcanSchema = this.$outer.fs2$kafka$vulcan$testkit$SchemaSuite$$codecAsSchema(writer);
                return this.registrySchema(readerSubject).map(arg_0 -> SchemaSuite.fs2$kafka$vulcan$testkit$SchemaSuite$$anon$2$$_$checkWriterCompatibility$$anonfun$1(vulcanSchema, arg_0));
            }

            public IO assertWriterCompatibility(Codec writer, String readerSubject) {
                return this.checkReaderCompatibility(writer, readerSubject).flatMap((Function1 & Serializable)compat -> IO$.MODULE$.delay((Function0 & Serializable)() -> {
                    this.assertWriterCompatibility$$anonfun$1$$anonfun$1((SchemaCompatibility.SchemaPairCompatibility)compat);
                    return BoxedUnit.UNIT;
                }));
            }

            public IO assertReaderCompatibility(Codec reader, String writerSubject) {
                return this.checkReaderCompatibility(reader, writerSubject).flatMap((Function1 & Serializable)compat -> IO$.MODULE$.delay((Function0 & Serializable)() -> {
                    this.assertReaderCompatibility$$anonfun$1$$anonfun$1((SchemaCompatibility.SchemaPairCompatibility)compat);
                    return BoxedUnit.UNIT;
                }));
            }

            private final SchemaMetadata registrySchema$$anonfun$1(String subject$1) {
                return this.client$1.getLatestSchemaMetadata(subject$1);
            }

            private final AvroSchema registrySchema$$anonfun$2$$anonfun$1(SchemaMetadata metadata$1) {
                return (AvroSchema)this.client$1.getSchemaById(metadata$1.getId());
            }

            private final Object assertWriterCompatibility$$anonfun$1$$anonfun$1$$anonfun$1(SchemaCompatibility.SchemaPairCompatibility compat$2) {
                Collection collection = syntax$.MODULE$.JavaUtilCollectionSyntax((Collection)compat$2.getResult().getIncompatibilities());
                return this.$outer.fs2$kafka$vulcan$testkit$SchemaSuite$$renderIncompatibilities((List<SchemaCompatibility.Incompatibility>)syntax.JavaUtilCollectionSyntax$.MODULE$.toList$extension(collection));
            }

            private final void assertWriterCompatibility$$anonfun$1$$anonfun$1(SchemaCompatibility.SchemaPairCompatibility compat$1) {
                ((Assertions)this.$outer).assertEquals((Object)compat$1.getResult().getCompatibility(), (Object)SchemaCompatibility.SchemaCompatibilityType.COMPATIBLE, () -> this.assertWriterCompatibility$$anonfun$1$$anonfun$1$$anonfun$1(compat$1), new Location("/home/runner/work/fs2-kafka/fs2-kafka/modules/vulcan-testkit-munit/src/main/scala/fs2/kafka/vulcan/testkit/SchemaSuite.scala", 117), (.less.colon.less)$less$colon$less$.MODULE$.refl());
            }

            private final Object assertReaderCompatibility$$anonfun$1$$anonfun$1$$anonfun$1(SchemaCompatibility.SchemaPairCompatibility compat$4) {
                Collection collection = syntax$.MODULE$.JavaUtilCollectionSyntax((Collection)compat$4.getResult().getIncompatibilities());
                return this.$outer.fs2$kafka$vulcan$testkit$SchemaSuite$$renderIncompatibilities((List<SchemaCompatibility.Incompatibility>)syntax.JavaUtilCollectionSyntax$.MODULE$.toList$extension(collection));
            }

            private final void assertReaderCompatibility$$anonfun$1$$anonfun$1(SchemaCompatibility.SchemaPairCompatibility compat$3) {
                ((Assertions)this.$outer).assertEquals((Object)compat$3.getResult().getCompatibility(), (Object)SchemaCompatibility.SchemaCompatibilityType.COMPATIBLE, () -> this.assertReaderCompatibility$$anonfun$1$$anonfun$1$$anonfun$1(compat$3), new Location("/home/runner/work/fs2-kafka/fs2-kafka/modules/vulcan-testkit-munit/src/main/scala/fs2/kafka/vulcan/testkit/SchemaSuite.scala", 131), (.less.colon.less)$less$colon$less$.MODULE$.refl());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{registrySchema$$anonfun$1(java.lang.String ), registrySchema$$anonfun$2(io.confluent.kafka.schemaregistry.client.SchemaMetadata ), fs2$kafka$vulcan$testkit$SchemaSuite$$anon$2$$_$checkReaderCompatibility$$anonfun$1(org.apache.avro.Schema org.apache.avro.Schema ), fs2$kafka$vulcan$testkit$SchemaSuite$$anon$2$$_$checkWriterCompatibility$$anonfun$1(org.apache.avro.Schema org.apache.avro.Schema ), assertWriterCompatibility$$anonfun$1(org.apache.avro.SchemaCompatibility$SchemaPairCompatibility ), assertReaderCompatibility$$anonfun$1(org.apache.avro.SchemaCompatibility$SchemaPairCompatibility ), registrySchema$$anonfun$2$$anonfun$1(io.confluent.kafka.schemaregistry.client.SchemaMetadata ), fs2$kafka$vulcan$testkit$SchemaSuite$$anon$2$$_$registrySchema$$anonfun$2$$anonfun$2(io.confluent.kafka.schemaregistry.avro.AvroSchema ), assertWriterCompatibility$$anonfun$1$$anonfun$1$$anonfun$1(org.apache.avro.SchemaCompatibility$SchemaPairCompatibility ), assertWriterCompatibility$$anonfun$1$$anonfun$adapted$1(org.apache.avro.SchemaCompatibility$SchemaPairCompatibility ), assertReaderCompatibility$$anonfun$1$$anonfun$1$$anonfun$1(org.apache.avro.SchemaCompatibility$SchemaPairCompatibility ), assertReaderCompatibility$$anonfun$1$$anonfun$adapted$1(org.apache.avro.SchemaCompatibility$SchemaPairCompatibility )}, serializedLambda);
            }
        });
    }

    public static /* synthetic */ Schema fs2$kafka$vulcan$testkit$SchemaSuite$$anon$2$$_$registrySchema$$anonfun$2$$anonfun$2(AvroSchema schema) {
        return schema.rawSchema();
    }

    public static /* synthetic */ SchemaCompatibility.SchemaPairCompatibility fs2$kafka$vulcan$testkit$SchemaSuite$$anon$2$$_$checkReaderCompatibility$$anonfun$1(Schema vulcanSchema$1, Schema regSchema) {
        return SchemaCompatibility.checkReaderWriterCompatibility((Schema)vulcanSchema$1, (Schema)regSchema);
    }

    public static /* synthetic */ SchemaCompatibility.SchemaPairCompatibility fs2$kafka$vulcan$testkit$SchemaSuite$$anon$2$$_$checkWriterCompatibility$$anonfun$1(Schema vulcanSchema$2, Schema regSchema) {
        return SchemaCompatibility.checkReaderWriterCompatibility((Schema)regSchema, (Schema)vulcanSchema$2);
    }
}

