/*
 * Decompiled with CFR 0.152.
 */
package fs2.kafka.vulcan;

import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import fs2.kafka.GenericDeserializer;
import fs2.kafka.Key;
import fs2.kafka.KeyOrValue;
import fs2.kafka.Value;
import fs2.kafka.package$;
import fs2.kafka.vulcan.AvroDeserializer;
import fs2.kafka.vulcan.AvroSettings;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Tuple2;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import vulcan.AvroError;
import vulcan.Codec;

public final class AvroDeserializer$ {
    public static final AvroDeserializer$ MODULE$ = new AvroDeserializer$();

    public <A> Codec<A> apply(Codec<A> codec) {
        return codec;
    }

    public final <F, A> Resource<F, GenericDeserializer<Key, F, A>> forKey$extension(Codec<A> $this, AvroSettings<F> settings, Sync<F> evidence$1) {
        return this.createDeserializer$extension($this, true, settings, evidence$1);
    }

    public final <F, A> Resource<F, GenericDeserializer<Value, F, A>> forValue$extension(Codec<A> $this, AvroSettings<F> settings, Sync<F> evidence$2) {
        return this.createDeserializer$extension($this, false, settings, evidence$2);
    }

    public final <F, A> Resource<F, GenericDeserializer<KeyOrValue, F, A>> createDeserializer$extension(Codec<A> $this, boolean isKey, AvroSettings<F> settings, Sync<F> F) {
        Either either = $this.schema();
        if (either instanceof Right) {
            Right right = (Right)either;
            Schema schema = (Schema)right.value();
            return cats.effect.package$.MODULE$.Resource().make(settings.createAvroDeserializer(isKey), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    KafkaAvroDeserializer deserializer = (KafkaAvroDeserializer)tuple2._1();
                    return F.delay((Function0)(JFunction0.mcV.sp & Serializable)() -> deserializer.close());
                }
                throw new MatchError((Object)tuple2);
            }, F).map((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    KafkaAvroDeserializer deserializer = (KafkaAvroDeserializer)tuple2._1();
                    SchemaRegistryClient schemaRegistryClient = (SchemaRegistryClient)tuple2._2();
                    return package$.MODULE$.Deserializer().instance((Function3 & Serializable)(topic, x$1, bytes) -> F.defer((Function0 & Serializable)() -> {
                        if (bytes == null || ((byte[])bytes).length == 0) {
                            return F.raiseError((Object)new IllegalArgumentException("Invalid Avro record: bytes is null or empty"));
                        }
                        int writerSchemaId = ByteBuffer.wrap(bytes).getInt(1);
                        ParsedSchema schema = schemaRegistryClient.getSchemaById(writerSchemaId);
                        Schema writerSchema = schema instanceof AvroSchema ? ((AvroSchema)schema).rawSchema() : null;
                        Either either = $this.decode(deserializer.deserialize(topic, bytes, schema), writerSchema);
                        if (either instanceof Right) {
                            Right right = (Right)either;
                            Object a = right.value();
                            return F.pure(a);
                        }
                        if (either instanceof Left) {
                            Left left = (Left)either;
                            AvroError error = (AvroError)left.value();
                            return F.raiseError((Object)error.throwable());
                        }
                        throw new MatchError((Object)either);
                    }), F);
                }
                throw new MatchError((Object)tuple2);
            });
        }
        if (either instanceof Left) {
            Left left = (Left)either;
            AvroError error = (AvroError)left.value();
            return cats.effect.package$.MODULE$.Resource().raiseError((Object)error.throwable(), F);
        }
        throw new MatchError((Object)either);
    }

    public final <A> String toString$extension(Codec<A> $this) {
        return new StringBuilder(17).append("AvroDeserializer$").append(System.identityHashCode(new AvroDeserializer<A>($this))).toString();
    }

    public final <A> int hashCode$extension(Codec<A> $this) {
        return $this.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final <A> boolean equals$extension(Codec<A> $this, Object x$1) {
        Object object = x$1;
        if (!(object instanceof AvroDeserializer)) return false;
        boolean bl = true;
        if (!bl) return false;
        Codec codec = x$1 == null ? null : ((AvroDeserializer)x$1).fs2$kafka$vulcan$AvroDeserializer$$codec();
        Codec<A> codec2 = $this;
        Codec codec3 = codec;
        if (codec2 != null) {
            if (!codec2.equals(codec3)) return false;
            return true;
        }
        if (codec3 == null) return true;
        return false;
    }

    private AvroDeserializer$() {
    }
}

