/*
 * Decompiled with CFR 0.152.
 */
package fs2.kafka.vulcan;

import cats.Show;
import cats.effect.kernel.Sync;
import fs2.kafka.vulcan.Auth;
import fs2.kafka.vulcan.Auth$BasicAuth$;
import fs2.kafka.vulcan.Auth$BearerAuth$;
import fs2.kafka.vulcan.Auth$NoAuth$;
import fs2.kafka.vulcan.SchemaRegistryClientSettings$;
import fs2.kafka.vulcan.SchemaRegistryClientSettings$SchemaRegistryClientSettingsImpl$;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function3;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public abstract class SchemaRegistryClientSettings<F> {
    public static <F> SchemaRegistryClientSettings<F> apply(String string, Sync<F> sync) {
        return SchemaRegistryClientSettings$.MODULE$.apply(string, sync);
    }

    public static int ordinal(SchemaRegistryClientSettings<?> schemaRegistryClientSettings) {
        return SchemaRegistryClientSettings$.MODULE$.ordinal(schemaRegistryClientSettings);
    }

    public static <F> Show<SchemaRegistryClientSettings<F>> schemaRegistryClientSettingsShow() {
        return SchemaRegistryClientSettings$.MODULE$.schemaRegistryClientSettingsShow();
    }

    public abstract String baseUrl();

    public abstract int maxCacheSize();

    public abstract SchemaRegistryClientSettings<F> withMaxCacheSize(int var1);

    public abstract SchemaRegistryClientSettings<F> withAuth(Auth var1);

    public abstract Map<String, String> properties();

    public abstract SchemaRegistryClientSettings<F> withProperty(String var1, String var2);

    public abstract SchemaRegistryClientSettings<F> withProperties(Seq<Tuple2<String, String>> var1);

    public abstract SchemaRegistryClientSettings<F> withProperties(Map<String, String> var1);

    public abstract F createSchemaRegistryClient();

    public abstract SchemaRegistryClientSettings<F> withCreateSchemaRegistryClient(Function3<String, Object, Map<String, String>, F> var1);

    public static final class SchemaRegistryClientSettingsImpl<F>
    extends SchemaRegistryClientSettings<F>
    implements Product,
    Serializable {
        private final String baseUrl;
        private final int maxCacheSize;
        private final Map properties;
        private final Function3 createSchemaRegistryClientWith;

        public static <F> SchemaRegistryClientSettingsImpl<F> apply(String string, int n, Map<String, String> map, Function3<String, Object, Map<String, String>, Object> function3) {
            return SchemaRegistryClientSettings$SchemaRegistryClientSettingsImpl$.MODULE$.apply(string, n, map, function3);
        }

        public static SchemaRegistryClientSettingsImpl<?> fromProduct(Product product) {
            return SchemaRegistryClientSettings$SchemaRegistryClientSettingsImpl$.MODULE$.fromProduct(product);
        }

        public static <F> SchemaRegistryClientSettingsImpl<F> unapply(SchemaRegistryClientSettingsImpl<F> schemaRegistryClientSettingsImpl) {
            return SchemaRegistryClientSettings$SchemaRegistryClientSettingsImpl$.MODULE$.unapply(schemaRegistryClientSettingsImpl);
        }

        public SchemaRegistryClientSettingsImpl(String baseUrl, int maxCacheSize, Map<String, String> properties, Function3<String, Object, Map<String, String>, Object> createSchemaRegistryClientWith) {
            this.baseUrl = baseUrl;
            this.maxCacheSize = maxCacheSize;
            this.properties = properties;
            this.createSchemaRegistryClientWith = createSchemaRegistryClientWith;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.baseUrl()));
            n = Statics.mix((int)n, (int)this.maxCacheSize());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.properties()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.createSchemaRegistryClientWith()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SchemaRegistryClientSettingsImpl)) return false;
            SchemaRegistryClientSettingsImpl schemaRegistryClientSettingsImpl = (SchemaRegistryClientSettingsImpl)object;
            if (this.maxCacheSize() != schemaRegistryClientSettingsImpl.maxCacheSize()) return false;
            String string = this.baseUrl();
            String string2 = schemaRegistryClientSettingsImpl.baseUrl();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Map<String, String> map = this.properties();
            Map<String, String> map2 = schemaRegistryClientSettingsImpl.properties();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            Function3<String, Object, Map<String, String>, F> function3 = this.createSchemaRegistryClientWith();
            Function3<String, Object, Map<String, String>, F> function32 = schemaRegistryClientSettingsImpl.createSchemaRegistryClientWith();
            if (function3 == null) {
                if (function32 == null) return true;
                return false;
            } else {
                if (!function3.equals(function32)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof SchemaRegistryClientSettingsImpl;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "SchemaRegistryClientSettingsImpl";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "baseUrl";
                }
                case 1: {
                    return "maxCacheSize";
                }
                case 2: {
                    return "properties";
                }
                case 3: {
                    return "createSchemaRegistryClientWith";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String baseUrl() {
            return this.baseUrl;
        }

        @Override
        public int maxCacheSize() {
            return this.maxCacheSize;
        }

        @Override
        public Map<String, String> properties() {
            return this.properties;
        }

        public Function3<String, Object, Map<String, String>, F> createSchemaRegistryClientWith() {
            return this.createSchemaRegistryClientWith;
        }

        @Override
        public SchemaRegistryClientSettings<F> withMaxCacheSize(int maxCacheSize) {
            return this.copy(this.copy$default$1(), maxCacheSize, this.copy$default$3(), this.copy$default$4());
        }

        @Override
        public SchemaRegistryClientSettings<F> withAuth(Auth auth) {
            Auth auth2 = auth;
            if (auth2 instanceof Auth.BasicAuth) {
                Auth.BasicAuth basicAuth = Auth$BasicAuth$.MODULE$.unapply((Auth.BasicAuth)auth2);
                String string = basicAuth._1();
                String string2 = basicAuth._2();
                String username = string;
                String password = string2;
                Object[] objectArray = new Tuple2[2];
                String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"basic.auth.credentials.source");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)"USER_INFO");
                String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"schema.registry.basic.auth.user.info");
                objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)new StringBuilder(1).append(username).append(":").append(password).toString());
                return this.withProperties((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            }
            if (auth2 instanceof Auth.BearerAuth) {
                String string;
                Auth.BearerAuth bearerAuth = Auth$BearerAuth$.MODULE$.unapply((Auth.BearerAuth)auth2);
                String token = string = bearerAuth._1();
                Object[] objectArray = new Tuple2[2];
                String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"bearer.auth.credentials.source");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)"STATIC_TOKEN");
                String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"bearer.auth.token");
                objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)token);
                return this.withProperties((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            }
            if (Auth$NoAuth$.MODULE$.equals(auth2)) {
                return this;
            }
            throw new MatchError((Object)auth2);
        }

        @Override
        public SchemaRegistryClientSettings<F> withProperty(String key, String value) {
            Map map = (Map)this.properties().updated((Object)key, (Object)value);
            String string = this.copy$default$1();
            int n = this.copy$default$2();
            Function3<String, Object, Map<String, String>, F> function3 = this.copy$default$4();
            return this.copy(string, n, (Map<String, String>)map, function3);
        }

        @Override
        public SchemaRegistryClientSettings<F> withProperties(Seq<Tuple2<String, String>> properties) {
            Map map = (Map)this.properties().$plus$plus((IterableOnce)properties.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            String string = this.copy$default$1();
            int n = this.copy$default$2();
            Function3<String, Object, Map<String, String>, F> function3 = this.copy$default$4();
            return this.copy(string, n, (Map<String, String>)map, function3);
        }

        @Override
        public SchemaRegistryClientSettings<F> withProperties(Map<String, String> properties) {
            Map map = (Map)this.properties().$plus$plus(properties);
            String string = this.copy$default$1();
            int n = this.copy$default$2();
            Function3<String, Object, Map<String, String>, F> function3 = this.copy$default$4();
            return this.copy(string, n, (Map<String, String>)map, function3);
        }

        @Override
        public F createSchemaRegistryClient() {
            return (F)this.createSchemaRegistryClientWith().apply((Object)this.baseUrl(), (Object)BoxesRunTime.boxToInteger((int)this.maxCacheSize()), this.properties());
        }

        @Override
        public SchemaRegistryClientSettings<F> withCreateSchemaRegistryClient(Function3<String, Object, Map<String, String>, F> createSchemaRegistryClientWith) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), createSchemaRegistryClientWith);
        }

        public String toString() {
            return new StringBuilder(57).append("SchemaRegistryClientSettings(baseUrl = ").append(this.baseUrl()).append(", maxCacheSize = ").append(this.maxCacheSize()).append(")").toString();
        }

        public <F> SchemaRegistryClientSettingsImpl<F> copy(String baseUrl, int maxCacheSize, Map<String, String> properties, Function3<String, Object, Map<String, String>, Object> createSchemaRegistryClientWith) {
            return new SchemaRegistryClientSettingsImpl<F>(baseUrl, maxCacheSize, properties, createSchemaRegistryClientWith);
        }

        public <F> String copy$default$1() {
            return this.baseUrl();
        }

        public int copy$default$2() {
            return this.maxCacheSize();
        }

        public <F> Map<String, String> copy$default$3() {
            return this.properties();
        }

        public <F> Function3<String, Object, Map<String, String>, F> copy$default$4() {
            return this.createSchemaRegistryClientWith();
        }

        public String _1() {
            return this.baseUrl();
        }

        public int _2() {
            return this.maxCacheSize();
        }

        public Map<String, String> _3() {
            return this.properties();
        }

        public Function3<String, Object, Map<String, String>, F> _4() {
            return this.createSchemaRegistryClientWith();
        }
    }
}

